// Classe pour la gestion de persistance pour NDataBlock<T>
//                         C.Magneville          04/99-03/2000
// LAL (Orsay) / IN2P3-CNRS  DAPNIA/SPP (Saclay) / CEA
#include "machdefs.h"
#include <stdio.h>
#include <stdlib.h>
#include <iostream.h>
#include <complex>
#include "pexceptions.h"
#include "fiondblock.h"

////////////////////////////////////////////////////////////////
// -------------------------------------------------------------------------
//   Les objets delegues pour la gestion de persistance 
// -------------------------------------------------------------------------

/*
template <class T>
void ObjFileIO< NDataBlock<T> >::ReadSelf(PInPersist& is)
template <class T>
void ObjFileIO< NDataBlock<T> >::WriteSelf(POutPersist& os)
*/

// Pour pouvoir ecrire des tableaux de complex, en attendant 
// PIn/POutPersist::Get/Put(complex<>)
#include "piocmplx.h"

template <class T>
FIO_NDataBlock<T>::FIO_NDataBlock()
{
dobj=new NDataBlock<T>;
ownobj=true;
}

template <class T>
FIO_NDataBlock<T>::FIO_NDataBlock(string const & filename) 
{
dobj=new NDataBlock<T>;
ownobj=true; 
Read(filename);
}

template <class T>
FIO_NDataBlock<T>::FIO_NDataBlock(const NDataBlock<T> & obj) 
{ 
dobj = new NDataBlock<T>(obj);
ownobj=true; 
}

template <class T>
FIO_NDataBlock<T>::FIO_NDataBlock(NDataBlock<T> * obj) 
{ 
dobj = obj;
ownobj=false; 
}

template <class T>
FIO_NDataBlock<T>::~FIO_NDataBlock()
{
if (ownobj && dobj) delete dobj;
}

template <class T>
AnyDataObj* FIO_NDataBlock<T>::DataObj()
{
return(dobj);
}

template <class T>
void FIO_NDataBlock<T>::SetDataObj(AnyDataObj & o)
{
NDataBlock<T> * po = dynamic_cast< NDataBlock<T> * >(&o);
if (po == NULL) throw TypeMismatchExc("FIO_NDataBlock<T>::SetDataObj() - Type Mismatch Error");
if (ownobj && dobj) delete dobj;
dobj = po; ownobj = false;
} 

template <class T>
uint_8 FIO_NDataBlock<T>::getMemOId() const
{
  uint_8 rv = 0;
  if (dobj) rv = (uint_8)(dobj->Begin());
  return(rv);
}

template <class T>
void FIO_NDataBlock<T>::ShareDataReference(PPersist & pp)
{
  FIO_NDataBlock<T> *ppo = dynamic_cast< FIO_NDataBlock<T> * >(&pp);
  if (ppo == NULL) throw TypeMismatchExc("FIO_NDataBlock<T>::ShareDataReference() - Type Mismatch Error");
  if (ppo->dobj) {
    if (dobj == NULL) { dobj = new NDataBlock<T>; ownobj = true; } 
    dobj->Share(*(ppo->dobj));
  }
}

template <class T>
PPersist* FIO_NDataBlock<T>::CloneSharedReference()
{
  FIO_NDataBlock<T> * ppo = new FIO_NDataBlock<T>;
  if (dobj) (ppo->dobj)->Share(*dobj);
  return(ppo);
}

template <class T>
void FIO_NDataBlock<T>::ReadSelf(PInPersist& is)
{
// On lit les 3 premiers uint_8
uint_8 itab[3];
is.Get(itab, 3);
if (dobj == NULL) dobj = new NDataBlock<T>(itab[1]);
else if (itab[1] != dobj->Size()) dobj->ReSize(itab[1]);
// On lit le tableau de nombres
PIOSReadArray(is, dobj->Data(), dobj->Size()); 
}


template <class T>
void FIO_NDataBlock<T>::WriteSelf(POutPersist& os) const
{
if (dobj == NULL)   return;  // Attention - $CHECK$ Reza 26/04/99
//  On ecrit 3 uint_8 
//  0 : Numero de version,  1 : Taille,  2  reserve a l
uint_8 itab[3];
itab[0] = 1;
itab[1] = dobj->Size();
itab[2] = 0;
os.Put(itab, 3);
//  On ecrit le tableau de nombres 
PIOSWriteArray(os, dobj->Data(), dobj->Size()); 
}

///////////////////////////////////////////////////////////////
#ifdef __CXX_PRAGMA_TEMPLATES__
// Instances des delegues FileIO (PPersist)
#pragma define_template FIO_NDataBlock<uint_1>
#pragma define_template FIO_NDataBlock<uint_2>
#pragma define_template FIO_NDataBlock<int_2>
#pragma define_template FIO_NDataBlock<int_4>
#pragma define_template FIO_NDataBlock<int_8>
#pragma define_template FIO_NDataBlock<uint_4>
#pragma define_template FIO_NDataBlock<uint_8>
#pragma define_template FIO_NDataBlock<r_8>
#pragma define_template FIO_NDataBlock<r_4>
#pragma define_template FIO_NDataBlock< complex<r_4> >
#pragma define_template FIO_NDataBlock< complex<r_8> >
#endif

#if defined(ANSI_TEMPLATES) || defined(GNU_TEMPLATES)
// Instances des delegues FileIO (PPersist)
template class FIO_NDataBlock<uint_1>;
template class FIO_NDataBlock<uint_2>;
template class FIO_NDataBlock<int_2>;
template class FIO_NDataBlock<int_4>;
template class FIO_NDataBlock<int_8>;
template class FIO_NDataBlock<uint_4>;
template class FIO_NDataBlock<uint_8>;
template class FIO_NDataBlock<r_8>;
template class FIO_NDataBlock<r_4>;
template class FIO_NDataBlock< complex<r_4> >;
template class FIO_NDataBlock< complex<r_8> >;
#endif
