// This may look like C code, but it is really -*- C++ -*-
//  Usuall mathematical functions and operations on arrays
//                     R. Ansari, C.Magneville   03/2000

#ifndef MathArray_SEEN
#define MathArray_SEEN

#include "machdefs.h"
#include "tarray.h"
#include <math.h>

namespace SOPHYA {

//       Class for simple mathematical operation on arrays 
//   Instanciated only for real and double (r_4, r_8) type arrays 
//                                                Reza 03/2000
template <class T>
class MathArray {
public:
// Applying a function 
  // Replaces the input array content with the result f(x)
  virtual TArray<T>&  ApplyFunctionInPlace(TArray<T> & a, Arr_DoubleFunctionOfX f);
  virtual TArray<T>&  ApplyFunctionInPlace(TArray<T> & a, Arr_FloatFunctionOfX f);
  // Creates a new array and fills it with f(x)
  virtual TArray<T>  ApplyFunction(TArray<T> const & a, Arr_DoubleFunctionOfX f);
  virtual TArray<T>  ApplyFunction(TArray<T> const & a, Arr_FloatFunctionOfX f);
  // Computing Mean-Sigma 
  virtual double     MeanSigma(TArray<T> const & a, double & mean, double & sig);
};

////////////////////////////////////////////////
//  Calcul de fonctions usuelles 
template <class T>
inline TArray<T> sin(const TArray<T>& a)
  { MathArray<T> ma;   return( ma.ApplyFunction(a, sin) ); }

template <class T>
inline TArray<T> cos(const TArray<T>& a)
  { MathArray<T> ma;   return( ma.ApplyFunction(a, cos) ); }

template <class T>
inline TArray<T> tan(const TArray<T>& a)
  { MathArray<T> ma;   return( ma.ApplyFunction(a, tan) ); }

template <class T>
inline TArray<T> asin(const TArray<T>& a)
  { MathArray<T> ma;   return( ma.ApplyFunction(a, asin) ); }

template <class T>
inline TArray<T> acos(const TArray<T>& a)
  { MathArray<T> ma;   return( ma.ApplyFunction(a, acos) ); }

template <class T>
inline TArray<T> atan(const TArray<T>& a)
  { MathArray<T> ma;   return( ma.ApplyFunction(a, atan) ); }

template <class T>
inline TArray<T> exp(const TArray<T>& a)
  { MathArray<T> ma;   return( ma.ApplyFunction(a, exp) ); }

template <class T>
inline TArray<T> log(const TArray<T>& a)
  { MathArray<T> ma;   return( ma.ApplyFunction(a, log) ); }

template <class T>
inline TArray<T> log10(const TArray<T>& a)
  { MathArray<T> ma;   return( ma.ApplyFunction(a, log10) ); }

template <class T>
inline double MeanSigma(const TArray<T>& a, double & mean, double & sig)
  { MathArray<T> ma;   return( ma.MeanSigma(a, mean, sig) ); }

template <class T>
inline double Mean(const TArray<T>& a)
  { MathArray<T> ma;  double mean, sig;  return( ma.MeanSigma(a, mean, sig) ); }


} // Fin du namespace

#endif
