#include "machdefs.h"

#include <math.h>
#include <iostream.h>

#include "nbrandom.h"
#include "tarrinit.h"
#include "tarray.h"
#include "fioarr.h"
#include "matharr.h"
#include "timing.h"


void tstioarr(TArray<int_4> & ia, TArray<int_4> & ib, TArray<int_4> & ic);
void tstmtx();

int main(int narg, char* arg[])
{

  SophyaInit();
  InitTim();   // Initializing the CPU timer


  int n = 5;
  int i,j,k;

  bool tio = false;
  if (narg > 1) tio = true;

  try {
  cout << "\n -----> Testing TArray <---- " << endl;  
  // We create a integer array SizeX=7, SizeY=5
  TArray<int_4> ia(7,5); 
  // We fill it with a sequence of numbers starting at 10., with step = 2.
  ia = Sequence(10., 2.);
  cout << " ----- matrix IA = \n " << ia << endl;
  // sub array extraction, Range(2,3) : starting position=2 , size=3
  TArray<int_4> ic = ia(Range(2,3),Range(1,2),Range(0));
  cout << " ----- matrix IC IA(Range(2,3),Range(1,2)) = \n " << ic << endl;
  // we set the sub-array to zero, this should reflect in the original array
  // sub-arrays share their data with parent array
  ic = 0;
  cout << " ----- matrix IC Apres (=0) = \n " << ic << endl;
  cout << " ----- matrix IA Apres IC=0 = \n " << ia << endl;

  cout << "  :::: 3 Dim arrays ::::: " << endl;
  TArray<int_4>::SetMaxPrint(1000);
  // Creating 3-dim array (X=8 x Y=7 x Z=2) , filling it with 5
  TArray<int_4> ib(8,7,2);
  ib = 5;
  cout << " ----- matrix IB = \n " << ib << endl;
  // Sub array extraction  X from 1 , size 4 - Y from 2 , size 3 , in Z default, from 0, size 1
  // we multiply this sub-array elements by 3
  ib(Range(1,4),Range(2,3), Range(0)) *= 3;
  cout << " -- matrix IB , Apres ib(Range(1,3),Range(2,1))*=3 : " << endl;
  cout << ib;

  // Creating a double array X=5 x Y=2
  TArray<r_4> fa(5,2);
  // fill it up with a sequence of 0. to 1.
  fa = Sequence(0.,1./(5*2));
  cout << " ------ TArray<r_4> fa(5,2) = \n" << fa << endl;
  // Create a new array from the original array , multiplying it by 2*Pi
  TArray<r_4> fa2 = fa*(float)(2.*M_PI); 
  cout << " ------ TArray<r_4> fa2=fa*2*Pi = \n" << fa2 << endl;
  // Compute sin(fa2) cos(fa2)
  cout << " ------ sin(fa2=fa*2*Pi) = \n" << sin(fa2) << endl;
  cout << " ------ cos(fa2=fa*2*Pi) = \n" << cos(fa2) << endl;

  if (tio) tstioarr(ia, ib, ic);

  }
  catch (PThrowable exc) {
    cerr << " catched Exception " << exc.Msg() << endl;
  }  
  catch (...) {
    cerr << " catched unknown (...) exception " << endl; 
  }  
  cout << " ---------------  END of Programme -------------- " << endl;
}

void tstioarr(TArray<int_4> & ia, TArray<int_4> & ib, TArray<int_4> & ic)
{
  cout << " ------ tstioarr(TArray<int_4> & ia, TArray<int_4> & ib, TArray<int_4> & ic) ---- " << endl;
  {
  cout << " >>>>>> Writing in  arrt.ppf <<<<<<< " << endl;
  POutPersist pos("arrt.ppf");
  // We write  the three arrays in the stream 
  pos << ia << ib << ic;
  cout << " >>>>>> Writing in  arrtn.ppf with names <<<<<<<" << endl;
  POutPersist posn("arrtn.ppf");
  string tag = "ArrIA";
  posn.PutObject(ia, tag);
  tag = "ArrIB";
  posn.PutObject(ib, tag);
  tag = "ArrIC";
  posn.PutObject(ic, tag);
  }

  {
  cout << " >>>>>>> Reading from  arrt.ppf  <<<<< " << endl;
  PInPersist pis("arrt.ppf");
  TArray<int_4> iaa, ibb, icc; 
  // We read the three arrays from the stream 
  pis >> iaa >> ibb >> icc;
  cout << " ----- matrix IAA = \n " << iaa << endl;
  cout << " ----- matrix IBB = \n " << ibb << endl;
  cout << " ----- matrix ICC = \n " << icc << endl;
  icc = 12;
  cout << " ----- matrix ICC (=12) = \n " << icc << endl;
  cout << " ----- matrix IAA (ICC=12) = \n " << iaa << endl;
  }

  {
  cout << " >>>>>>> Reading from  arrtn.ppf  <<<<< " << endl;
  PInPersist pis("arrtn.ppf");
  TArray<int_4> iaa, ibb, icc; 
  // We read the three arrays from the stream 
  string tag = "ArrIC";
  pis.GetObject(icc, tag);
  tag = "ArrIB";
  pis.GetObject(ibb, tag);
  tag = "ArrIA";
  pis.GetObject(iaa, tag);

  cout << " ----- matrix IAAA = \n " << iaa << endl;
  cout << " ----- matrix IBBB = \n " << ibb << endl;
  cout << " ----- matrix ICCC = \n " << icc << endl;
  icc = 68;
  cout << " ----- matrix ICCC (=12) = \n " << icc << endl;
  cout << " ----- matrix IAAA (ICC=12) = \n " << iaa << endl;
  }


}
