// This may look like C code, but it is really -*- C++ -*-
//                         C.Magneville          05/99
#ifndef TVector_SEEN
#define TVector_SEEN

#include "tmatrix.h"

namespace SOPHYA {

template <class T>
class TVector : public TMatrix<T> {
public:
  // Creation / destruction 
  TVector();
  TVector(uint_4 n, short lcv=ColumnVector, short mm=AutoMemoryMapping);
  TVector(const TVector<T>& v);
  TVector(const TVector<T>& v, bool share);
  TVector(const TArray<T>& a);
  TVector(const TArray<T>& a,  bool share, short mm=CMemoryMapping, short lcv=ColumnVector);

  virtual ~TVector();

  inline  TVector<T>& operator = (const TVector<T>& a)
                       { Set(a);  return(*this); }


  // Gestion taille/Remplissage
  void ReSize(uint_4 n, short lcv=SameVectorType ); 
  void Realloc(uint_4 n, short lcv=SameVectorType, bool force=false);

  // Sub-Vector extraction $CHECK$ Reza 03/2000  Doit-on declarer cette methode const ?
  TVector<T> SubVector(Range relt) const ;
  inline TVector<T> operator () (Range relt) const 
                    { return SubVector(relt); }

  // Informations pointeur/data
  inline uint_4 NElts() const {return Size(); }
  
  // Inline element acces methods 
  inline T const& operator()(uint_4 n) const;
  inline T&       operator()(uint_4 n);

  // Operateur d'affectation
  inline  TMatrix<T>&  operator = (Sequence seq)    { SetSeq(seq); return(*this); }

  // Operations diverses  avec une constante
  inline  TVector<T>&  operator = (T x)             { SetT(x); return(*this); }
  inline  TVector<T>&  operator += (T x)            { Add(x); return(*this); }
  inline  TVector<T>&  operator -= (T x)            { Sub(x); return(*this); }
  inline  TVector<T>&  operator *= (T x)            { Mul(x); return(*this); }
  inline  TVector<T>&  operator /= (T x)            { Div(x); return(*this); }

  //  operations avec matrices 
  inline  TVector<T>&  operator += (const TVector<T>& a)  { AddElt(a); return(*this); }
  inline  TVector<T>&  operator -= (const TVector<T>& a)  { SubElt(a); return(*this); }

  // Norme(^2) 
  T Norm2() const ;

  virtual string InfoString() const;

};

//  ---- inline acces methods ------
template <class T>
inline T const& TVector<T>::operator()(uint_4 n) const
{
#ifdef SO_BOUNDCHECKING
  if (veceli__ == 0)   CheckBound(n, 0, 0, 0, 0, 4);
  else   CheckBound(0, n, 0, 0, 0, 4);
#endif
  return ( *( mNDBlock.Begin()+ offset_ + n*step_[veceli_] ) );
}

template <class T>
inline T & TVector<T>::operator()(uint_4 n) 
{
#ifdef SO_BOUNDCHECKING
  if (veceli__ == 0)   CheckBound(n, 0, 0, 0, 0, 4);
  else   CheckBound(0, n, 0, 0, 0, 4);
#endif
  return ( *( mNDBlock.Begin()+ offset_ + n*step_[veceli_] ) );
}

// Typedef pour simplifier et compatibilite Peida
typedef TVector<r_8> Vector;

} // Fin du namespace

#endif
