// $Id: tvector.cc,v 1.3 2000-04-05 15:44:17 ansari Exp $
//                         C.Magneville          04/99
#include "machdefs.h"
#include <stdlib.h>
#include "pexceptions.h"
#include "tvector.h"

////////////////////////////////////////////////////////////////
//**** Createur, Destructeur

template <class T>
TVector<T>::TVector()
  : TMatrix<T>()
{
}

template <class T>
TVector<T>::TVector(uint_4 n, short lcv, short mm)
// Constructeur 
  : TMatrix<T>(1,1,mm)
{
  lcv = SelectVectorType(lcv);
  ReSize(n,lcv);
}


template <class T>
TVector<T>::TVector(const TVector<T>& a)
// Constructeur par copie (partage si "a" temporaire).
  : TMatrix<T>(a)
{
}

template <class T>
TVector<T>::TVector(const TVector<T>& a, bool share)
// Constructeur par copie avec possibilite de forcer le partage ou non.
: TMatrix<T>(a, share)
{
}

template <class T>
TVector<T>::TVector(const TArray<T>& a)
: TMatrix<T>(a)
{
  if ( (size_[0] != 1) && (size_[1] != 1) )
    throw SzMismatchError("TVector<T>::TVector(const TArray<T>& a) NRows()!=1 && NCols()!=1 ");
}


template <class T>
TVector<T>::TVector(const TArray<T>& a, bool share, short mm, short lcv )
: TMatrix<T>(a, share, mm)
{
  if ( (size_[0] != 1) && (size_[1] != 1) )
    throw SzMismatchError("TVector<T>::TVector(const TArray<T>& a) NRows()!=1 && NCols()!=1 ");
  if ( (size_[0] == 1) && (size_[1] == 1) ) {
    if (lcv == SameVectorType) lcv = a.GetVectorType();
    if ( (lcv != ColumnVector) && (lcv != RowVector) ) lcv = GetDefaultVectorType();
    veceli_ = (lcv ==  ColumnVector ) ?  marowi_ : macoli_;
  }
}

template <class T>
TVector<T>::~TVector()
// Destructeur
{

}

template <class T>
void TVector<T>::ReSize(uint_4 n, short lcv)
{
  if( n == 0 ) 
    throw(SzMismatchError("TVector::ReSize() n = 0 "));
  uint_4 r,c;
  if (lcv == SameVectorType)  lcv = GetVectorType();
  else if ( (lcv != ColumnVector) && (lcv != RowVector) ) lcv = GetDefaultVectorType();
  if (lcv == ColumnVector) { r = n;  c = 1; }
  else { c = n; r = 1; }
  TMatrix<T>::ReSize(r,c);
  veceli_ = (lcv ==  ColumnVector ) ?  marowi_ : macoli_;
}

template <class T>
void TVector<T>::Realloc(uint_4 n, short lcv, bool force)
{
  if( n == 0 ) 
    throw(SzMismatchError("TVector::Realloc() n = 0 "));
  uint_4 r,c;
  if (lcv == SameVectorType)  lcv = GetVectorType();
  else if ( (lcv != ColumnVector) && (lcv != RowVector) ) lcv = GetDefaultVectorType();
  if (lcv == ColumnVector) { r = n;  c = 1; }
  else { c = n; r = 1; }
  TMatrix<T>::Realloc(r,c,SameMemoryMapping,force);
  veceli_ = (lcv ==  ColumnVector ) ?  marowi_ : macoli_;
}

// $CHECK$ Reza 03/2000  Doit-on declarer cette methode const ?
template <class T>
TVector<T> TVector<T>::SubVector(Range relt) const
{
  Range rr, cr;
  if (GetVectorType() == ColumnVector )  rr = relt; 
  else cr = relt;
  TMatrix<T> const & mtx = (*this);
  TVector sv( mtx(rr, cr) , true, GetVectorType(), GetMemoryMapping() );
  sv.SetTemp(true);
  return(sv);  
}

template <class T>
T TVector<T>::Norm2() const
{
  T ret = 0;
  for(uint_8 k=0; k<Size(); k++)   ret += (*this)(k)*(*this)(k);
  return ret;
}

template <class T>
string TVector<T>::InfoString() const
{
  string rs = "TVector<";
  rs += typeid(T).name();
  char buff[64];
  sprintf(buff, ">(%ld) (nr=%ld, nc=%ld)", (long)NElts(), (long)NRows(), (long)NCols());
  rs += buff;
  return(rs);  

}

///////////////////////////////////////////////////////////////
#ifdef __CXX_PRAGMA_TEMPLATES__
#pragma define_template TVector<uint_2>
#pragma define_template TVector<int_4>
#pragma define_template TVector<int_8>
#pragma define_template TVector<r_4>
#pragma define_template TVector<r_8>
#pragma define_template TVector< complex<r_4> > 
#pragma define_template TVector< complex<r_8> > 
#endif

#if defined(ANSI_TEMPLATES) || defined(GNU_TEMPLATES)
template class TVector<uint_2>;
template class TVector<int_4>;
template class TVector<int_8>;
template class TVector<r_4>;
template class TVector<r_8>;
template class TVector< complex<r_4> >;
template class TVector< complex<r_8> >;
#endif

