//     Utility classes for template numerical arrays
//                     R. Ansari, C.Magneville   03/2000

#include "machdefs.h"
#include "utilarr.h"

// Classe utilitaires
Sequence::Sequence(double start, double step, Arr_DoubleFunctionOfX f)
{
  start_ = start;
  step_ = step;
  myf_ = f;
}

double Sequence::operator () (uint_4 k)
{
  double x = start_+(double)k*step_;
  if (myf_)  return(myf_(x));
  return x;
}

Range::Range(uint_4 start, uint_4 end, uint_4 size, uint_4 step)
{
  start_ = start;
  step_ = (step > 0) ? step : 1;
  if (end > start) {  // Taille calcule automatiquement 
    end_ = end;
    if (step_ > ((end_-start_)+1))  size_ = 1;
    else size_ = ((end-start)+1)/step_;
  }
  else {     // Taille fixee
    size_ = size;
    end_ = start_+size_*step_;
  }
}

/*
Range & Range::operator = (uint_4 start)
{
  start_ = start;
  size_ = 1;
  step_ = 1;
  return (*this);
}
*/


IdentityMatrix::IdentityMatrix(double diag, uint_4 n)
{
  size_ = n;
  diag_ = diag;
}
