#ifndef PIHISTO2D_H
#define PIHISTO2D_H

#include "pisysdep.h"
#include PIMENU_H 
#include PIMENUBAR_H 
#include PIOPTMENU_H

#include "histos2.h"
#include "piscdrawwdg.h"

////////////////////////////////////////////////////////////////////
class PIHisto2D : public PIScDrawer {
public:
                     PIHisto2D(Histo2D* histo, bool ad=false);
  virtual            ~PIHisto2D();
          void       UseColors(bool fg=false, CMapId cmap=CMAP_GREYINV32);
          void       UseScale(unsigned short type=0,float logscale=10.);
          void       UseDisplay(unsigned short type=0, float fnpt=0.5);
          void       UseDyn(float hmin=1., float hmax=-1.);
          void       UseFrac(float frmin=0.1, float frmax=0.9);
          void       Print(int lp=0);
  virtual void       Draw(PIGraphicUC* g,float xmin,float ymin,float xmax,float ymax);
  virtual void       UpdateSize();
  virtual void       DrawStats(PIGraphicUC* g);

  inline Histo2D*       Histogram() { return(mHisto); }
  inline bool           Color() { return(mFgCol); }
  inline CMapId         ColMap() { return(mCmap); }
  inline unsigned short TypScale() { return(mTypScal); }
  inline unsigned short TypDisplay() { return(mTypDisp); }
  inline float          FPoints() { return(mFPoints); }
  inline float          HMax() { return(mHMax);}
  inline float          HMin() { return(mHMin);}
  inline float          FMax() { return(mFracMax);}
  inline float          FMin() { return(mFracMin);}
  inline float          LogScale() { return(mLogScale);}

protected:
  int NPixBin(PIGraphicUC* g);
  char HPrint2(float f);

  Histo2D* mHisto;
  bool mFgCol;
  CMapId mCmap;
  unsigned short mTypScal;
  unsigned short mTypDisp;
  float mFPoints;
  float mHMin,mHMax;
  float mFracMin,mFracMax;
  float mLogScale;
};

////////////////////////////////////////////////////////////////////
class PIH2DWdg : public PIScDrawWdg {
public:
                     PIH2DWdg(PIContainerGen *par, char *nom, int sx=300, int sy=300, 
                              int px=0, int py=0);
                     ~PIH2DWdg();

  void               SetHisto(Histo2D* histo);
  inline PIHisto2D*  GetPIHisto() {return mPih;}

  virtual string     GetClickText(float x, float y); 
  virtual void       But3Press(int x, int y);

protected:
  PIHisto2D*  mPih;

};

////////////////////////////////////////////////////////////////////
class H2WinArg : public PIWindow {
public :
               H2WinArg(PIH2DWdg *par);
               ~H2WinArg();
          void SetPIH2DWdg(PIH2DWdg* h2wdg);
          void SetText();
          void GetText();
  virtual void Process(PIMessage msg, PIMsgHandler* sender, void* data=NULL);

protected:
  PIH2DWdg  * mH2Wdg;

  PIPUMenu  * mPop[3];
  PIOptMenu * mOPop[3];
  PIButton  * mBut[4];
  PILabel   * mLab[4];
  PIText    * mText[3];
  PIScale   * mPScal;

  bool mFgCol;
  CMapId mCmap;
  unsigned short mTypScal;
  unsigned short mTypDisp;
  float mFPoints;
  float mHMin,mHMax;
  float mFracMin,mFracMax;
  float mLogScale;
};

#endif
