// This may look like C code, but it is really -*- C++ -*-
//--------------------------------------------------------------------------
// File and Version Information:
//      $Id: specresp.h,v 1.4 2000-04-06 17:10:51 ansari Exp $
//
// Description:
//
// History (add to end):
//      Sophie   Oct, 1999  - creation
//
//------------------------------------------------------------------------
#ifndef SPECRESP_H_SEEN
#define SPECRESP_H_SEEN

#include "machdefs.h"
#include "anydataobj.h"
#include <iostream.h>
//------------------------------------
// Collaborating Class Declarations --
//------------------------------------

//              ---------------------
//              -- Class Interface --
//              ---------------------

// ***IMPORTANT*** All frequencies are expressed in GHz  (10^9 Hz)
namespace SOPHYA {
  
  class SpectralResponse : public AnyDataObj
  {
    
  public:
    //Constructor
    SpectralResponse(double numin=0., double numax=1.);
    
    // destructor
    virtual ~SpectralResponse();
    
    //
    //  Member Functions
    //
    
    //  The transmission() function is virtual: 
    virtual double transmission(double nu) const =0 ; 
    
    inline double operator() (double nu) const { return(transmission(nu)); }
    
    virtual void      Print(ostream& os)  const;
    
    virtual double minFreq() const;
    virtual double maxFreq() const;
    virtual double meanFreq() const;
    virtual double peakFreq() const;
    virtual double peakTransmission() const;

    // For changing the min/max frequency
    virtual void   setMinMaxFreq(double numin, double numax);

    virtual double IntegratedSpect(double numin, double numax) const ;
    virtual double logIntegratedSpect(double numin, double numax) const ;
    virtual double IntegratedSpect() const ;
    virtual double logIntegratedSpect() const ;
    
  protected:
    double _numin;
    double _numax;
  };
  
  
  // definition of the << operator
  inline ostream& operator << (ostream& s,  SpectralResponse const & sr)
    {  sr.Print(s);  return(s);  }
  
  
  
}

#endif




