// Utilisation des flots d'entree-sortie C++
#include <iostream.h>
// Utilisation de la classe Image<T>
#include "ntoolsinit.h"
#include "cimage.h"
// Utilisation des generateurs aleatoires
#include "nbrandom.h"

// Test des NDataBlock
#include "ndatablock.h"
#include "fiondblock.h"
#include <complex>


// -------- Le programme principal ---------

main(int narg, char *arg[])
{
int i,j;

// ----- ATTENTION -------
// Initialisation de Sophya
// A faire au debut de main()
SophyaInit();

cout << " ........ Debut de timg.cc ....... " << endl;
// declaration et creation d'une image de type flottant 300x200
ImageR4  img(300, 200);
ImageR4  imgo(300, 200);
// Remplissage de l'image Tirage aleatoire plat entre 1000-2000
for(i=0; i<300; i++)
  for(j=0; j<200; j++) img(i,j) = imgo(i,j) =  frand01()*1000.+1000.;
// Verification de la dynamique de l'image
img.CheckDyn();
img.Print();
// On sauve l'image ds img.ppf (fichier  format PPersist)
img.Write("img.ppf");

// On rajoute du bruit a l'image (Gaussienne de sigma=3)
for(i=0; i<300; i++)
  for(j=0; j<200; j++) img(i,j) += NorRand()*3. ;

// Verification de la dynamique de l'image
img.CheckDyn();
img.Print();

// On verifie la date de creation du fichier .ppf
  {
  string ppfname = "img.ppf";
  PInPersist pin(ppfname, false);
  cout << "Fichier PPF: " << ppfname << " Version= " << pin.Version() 
       << " Created: " << pin.CreationDate() << endl;
  }
// On cree une nouvelle image 
ImageR4  img2;
// On lit le contenu du fichier imgin.ppf
img2.Read("img.ppf");
// On calcule la difference entre les images img et img2
//    Avant ajout de bruit
cout << "\n imgo(sansbruit) - img2 (fromfile) == 0 ? " << endl;
imgo -= img2;
// Verification de la dynamique de l'image soustraite
imgo.CheckDyn();
imgo.Print();

//    Apres  ajout de bruit
cout << " img(avecbruit) - img2 (fromfile) == Noise, sigma=1 ? " << endl;
img -= img2;
// Verification de la dynamique de l'image soustraite
img.CheckDyn();
img.Print();

// ---- Test des NDataBlock 
cout << "\n ----------> Test des NDataBlock <r_8>" << endl;
NDataBlock<r_8> db(20);
for(i=0; i<20; i++) db(i) = i*5.;
cout << " DataBlock<r_8> i*5 : (db)" << endl;
cout << db << endl;
NDataBlock<r_8> db2(db,false);
cout << " DataBlock<r_8> (db2=db) - db" << endl;
cout << db2-db << endl;

FIO_NDataBlock<r_8> fdb(db);
fdb.Write("db_r8.ppf");
cout << " DataBlock<r_8> db -> File db_r8.ppf" << endl;
FIO_NDataBlock<r_8> fdb2("db_r8.ppf");
cout << " DataBlock<r_8> Frome file(db_r8.ppf) - db" << endl;
cout << (NDataBlock<r_8>)fdb2-db << endl;

cout << "\n\n ----------> Test des NDataBlock <complex<double>>" << endl;
NDataBlock< complex<double> > zb(20);
for(i=0; i<20; i++) {complex<double> z(i*10., 0.1*i); zb(i) = z; }
cout << " DataBlock<complex<double>>  (zb) = " << endl;
cout << zb << endl;
FIO_NDataBlock< complex<double> > fzb(zb);
fzb.Write("zb_z8.ppf");
FIO_NDataBlock< complex<double> > fzb2("zb_z8.ppf");
cout << " DataBlock<complex<double>> Frome file(zb_z8.ppf) - db" << endl;
cout << (NDataBlock< complex<double> >)(fzb2) ;

cout << "\n -------> Test de typeinfo : " << endl;
string st;
ImageR4 ir;
ImageU2* irp;

st = typeid(NDataBlock<r_8>).name();
cout << "typeid(NDataBlock<r_8>).name() = " << st << endl;
st = typeid(ir).name();
cout << "typeid(ir).name() - " << st << endl;
st = typeid(irp).name();
cout << "typeid(irp).name() - " << st << endl;
cout << "\n ========= Fin de timg.cc ======== " << endl;
exit(0);
}
