#ifndef FITSFILE_H
#define FITSFILE_H

#include "ndatablock.h"
#include "dvlist.h"
#include "FitsIO/fitsio.h" 

#define OPENFILE    0
#define CREATEFILE  1
#define LEN_KEYWORD 9

class FitsFile
{

public:

  FitsFile();
  //  FitsFile(char flnm[],int iomode,int hdunum= 0);
  virtual ~FitsFile();

inline bool IsFitsImage() const { return (hdutype_ == IMAGE_HDU);}
inline bool IsFitsTable() const {return (hdutype_ == ASCII_TBL || hdutype_ == BINARY_TBL);}
  void   ReadF(char flnm[],int hdunum= 0); 
  void    WriteF(char flnm[],int hdunum= 0); 
  void    GetSingleColumn(double* map, int nentries) const;
  void    GetSingleColumn(float*  map, int nentries) const;
  void    GetSingleColumn(int* map, int nentries) const;
  int     nbDimOfImage() const;
inline int nbOfImageData() const { return nbData_; }
 inline void dimOfImageAxes(int& naxis1, int& naxis2, int& naxis3) const
   {
     naxis1 = naxis1_;
     naxis2 = naxis2_;
     naxis3 = naxis3_;
   }
  int     NbColsFromFits() const;
  char    ColTypeFromFits(int nocol) const;
  int     NentriesFromFits(int nocol) const;
  string  ColNameFromFits(int nocol) const;
  int     ColStringLengthFromFits(int nocol) const;
  inline const DVList& DVListFromFits() const { return dvl_;}
  void GetBinTabFCol(double* valeurs, int nentries, int NoCol) const;
  void GetBinTabFCol(float* valeurs, int nentries, int NoCol) const;
  void GetBinTabFCol(int* valeurs, int nentries,  int NoCol) const;
  void GetBinTabFCol(char** valeurs,int nentries, int NoCol) const;
  // Write elements into the FITS data array
  void putImageToFits( int nbData, double* map) const;
  void putImageToFits(int nbData, float* map ) const;
  void putImageToFits(int nbData, int* map) const;
  void putColToFits(int nocol, int nentries, double* donnees) const;
  void putColToFits(int nocol, int nentries, float* donnees) const;
  void putColToFits(int nocol, int nentries, int* donnees) const;
  void putColToFits(int nocol, int nentries, char** donnees) const;
  // Write elements into an ASCII or binary table column
  void makeHeaderImageOnFits(char type, int naxis1,int naxis2,int naxis3) const;
  void makeHeaderBntblOnFits ( char* fieldType, char** Noms, int nentries, int tfields, DVList &dvl, char* extname,  vector<int> taille_des_chaines) const;

  void readheader();
  void printerror(int&) const;
  void printerror(int&,char* texte) const;
  protected:  
    virtual void    ReadFromFits(const FitsFile& ff)=0;           
    virtual void    WriteToFits(const FitsFile& ff)=0;           
    //    virtual void*   getColFromObj(int colNr)=0;
private:

  void read_image ();
  void GetBinTabParameters();
  void writeSignatureOnFits() const; 

  
  fitsfile *fptr_; // pointer to the FITS file, defined in fitsio.h
  
  int hdutype_; // image or bintable ?
  int hdunum_;  // index of header to read/write


  // fits-Image parameters 
  int bitpix_;
  int naxis_;
  int naxis1_;
  int naxis2_;
  int naxis3_;
  int nbData_;

  // Bintable parameters
  int nrows_;
  vector<int> repeat_;

  int nbcols_;
  vector<string> noms_; // column names
  vector<char> types_;  // types of columns (D: double, E: float, I: integers
                        // A: char*)
  vector<int>  taille_des_chaines_; // length of the char* variables


  DVList dvl_;
};
#endif
