#include "pexceptions.h"
#include "fitsntuple.h"
///////////////////////////////////////////////////////////
//   Les objets delegues pour la gestion de persistance sur fichiers fits 
//    pout NTuple
///////////////////////////////////////////////////////////


#define LONNOM 8
#define LONNOM1  (LONNOM+1)



FITS_NTuple::FITS_NTuple()
{
  dobj_ = new NTuple;
  column_ = NULL;
  ownobj=true;
}

FITS_NTuple::FITS_NTuple(char inputfile[],int hdunum)
{
  dobj_ = new NTuple;
  column_ = NULL;
  ownobj=true; 

  ReadF(inputfile,hdunum);
}


FITS_NTuple::FITS_NTuple(const NTuple & obj) 
{ 
  dobj_ = new NTuple(obj);
  column_ = NULL;
  ownobj=true; 
}


FITS_NTuple::~FITS_NTuple()
{
  if (ownobj && dobj_ != NULL) delete dobj_;
  if (column_ != NULL) delete [] column_;
}

void FITS_NTuple::Write(char outputfile[], int hdunum)
{
  WriteF(outputfile, hdunum);
}

void FITS_NTuple::ReadFromFits(const FitsFile& fn)
{
  if (!fn.IsFitsTable())
    {
      throw PException("ReadFromFits: the fits file seems not to be a bintable nor ASCII table");
    }
  int nbcols, nbentries;
  nbcols = fn.NbColsFromFits();
  cout << " nbcols= " << nbcols << endl;
  nbentries = 0;
  for (int k=0; k<nbcols; k++) nbentries=max( nbentries, fn.NentriesFromFits(k) );
  
  char ** ColName = new char*[nbcols];
  
  for (int k=0; k<nbcols;k++) 
    {
      ColName[k] = new char[LONNOM1]; 
      strncpy(ColName[k], fn.ColNameFromFits(k).c_str(),LONNOM);
      ColName[k][LONNOM] =  '\0';
    }
  for (int k=0; k<nbcols;k++)
    {
      char ss= fn.ColTypeFromFits(k);
      string type;
      if (ss != 'E') 
	{
	  if (ss == 'D') type= string("double");
	  else
	    if (ss == 'I') type= string("integer");
	    else
	      if (ss == 'A') type = string("char*");
	      else
		type = string("unknown");
	  cout << " WARNING: the column " << k << " on fits file is not float but : " << type << endl;
	} 
    }
  if(dobj_ == NULL) 
    { 
      dobj_= new NTuple(nbcols,ColName);
      ownobj= true;      
    }
  else 
    {
      dobj_->Clean();
      (*dobj_) = NTuple(nbcols,ColName);
    }
  for (int k=0; k<nbcols;k++) 
    {
      delete [] ColName[k];
    }
  delete [] ColName;
  cout << " preparation du tabeau column" << endl;
    if (column_ != NULL) delete [] column_;
    column_ = new float[nbentries];

  // j'initialise le NTuple a zero, pour le dimensionner
  // (SetVal suppose que le ntuple est deja dimensionne)
  cout << " nbcol= " << nbcols << endl;
  r_4* ligne = new r_4[nbcols];
    for (int k=0; k<nbcols; k++) ligne[k]=0.;
    for (int k=0; k<nbentries;k++) dobj_->Fill(ligne);
  cout << " ntuple initialise a zero" << endl;
    delete [] ligne;
   cout << "debut boucle nbcol= " << nbcols << endl;
  for (int k=0; k<nbcols;k++) 
    {
      cout << " avant lecture col. no " << k << endl;
      fn.GetBinTabFCol(column_, nbentries, k);
      cout << " lecture effectuee " << endl;
      for (int nent=0; nent<nbentries; nent++) dobj_->SetVal(nent,k, column_[nent]);
      cout << " valeurs inserre dans ntuple " << endl;
    }
  dobj_->Info()=fn.DVListFromFits();
}
void FITS_NTuple::WriteToFits(const FitsFile& fn)
{
  if(dobj_ == NULL) 
    {
      cout << " WriteToFits:: dobj_= null " << endl;
      return;
    }

  // table will have 'ncols'  columns
  int ncols = dobj_->NVar();

  // table will have 'nrows' rows
  int nentries = dobj_->NEntry();

  // get names and values from the join DVList object
  DVList dvl= dobj_->Info();
  // extension name
  char* extname = "NTuple_Binary_tbl"; 
  dvl.Print();

  char** Noms = new char*[ncols];   
  for (int k=0; k< ncols; k++)
    {
      Noms[k]= new char[LONNOM1];
      strncpy(Noms[k],dobj_->NomIndex(k),LONNOM1);
      cout << " nom entre dans ntuple: " << Noms[k] << endl;
    }
  // la librairie fitsio ecrit colonne par colonne 
  char* type= new char[ncols+1];
  for (int k=0;k<ncols+1;k++) type[k]='E';
  type[ncols]='\0';
  vector<int> dummy;
  fn.makeHeaderBntblOnFits(type,Noms, nentries, ncols, dvl, extname, dummy);
   for (int k=0; k< ncols; k++)
    {
      delete [] Noms[k];
    }
   delete [] Noms;
   delete [] type;
   for (int k=0; k<ncols;k++) putColToFits(k, nentries, getColFromObj(k));

   cout << " fin d'ecriture "<< endl; 
}

float* FITS_NTuple::getColFromObj(int colNr)
{
  if (column_ != NULL)
    {
      delete [] column_;
      column_ = NULL;
    }
  column_ = new float[dobj_->NEntry()];
  for(int j = 0; j < dobj_->NEntry(); j++) column_[j]= dobj_->GetVal(j,colNr);
  return column_;
}
