// Guy Le Meur 03/2000


#ifndef FITSXNTuple_SEEN
#define FITSXNTuple_SEEN
#include "xntuple.h"
#include "anydataobj.h"
#include "ppersist.h"
#include "fitsfile.h"

namespace SOPHYA {
///////////////////////////////////////////////////////////
//   Les objets delegues pour la gestion de persistance sur fichiers fits 
//   pour XNTuple
///////////////////////////////////////////////////////////

class  FITS_XNTuple : public FitsFile  
{

public:
FITS_XNTuple();
FITS_XNTuple(char inputfile[],int hdunum=2);
FITS_XNTuple(const XNTuple & obj);
~FITS_XNTuple();
void Write(char outputfile[], int hdunum=2);
inline operator XNTuple() { return(*dobj_); }

protected:

  // implementation de FitsFile
  virtual void  ReadFromFits(const FitsFile& fn);
virtual void    WriteToFits(const FitsFile& fn);
void*   getColFromObj(int colNr);
double* getColDFromObj(int colNr);
float*  getColFFromObj(int colNr);
int*    getColIFromObj(int colNr);
char**  getColSFromObj(int colNr);

  // attributs de classe
  XNTuple* dobj_;
  bool    ownobj;
  double* dcolumn_;
  float*  fcolumn_;
  int*    icolumn_;
  char**  ccolumn_;
};
//////////////////////////////////////////////////////////////////


} // Fin du namespace

#endif
