//     Utility classes for template numerical arrays
//                     R. Ansari, C.Magneville   03/2000

#include "machdefs.h"
#include "utilarr.h"
#include "srandgen.h"

// Classe utilitaires

RandomSequence::RandomSequence(int typ, double m, double s)
{
  typ_ = (typ == Flat) ? Flat : Gaussian;
  mean_ = m;
  sig_ = s;
}

double RandomSequence::Rand()
{
  if (typ_ == Flat) 
    return(drandpm1()*sig_ + mean_);
  else return(GauRnd(mean_, sig_));
}


Sequence::Sequence(double start, double step, Arr_DoubleFunctionOfX f)
  : rseq_(RandomSequence::Gaussian)
{
  start_ = start;
  step_ = step;
  myf_ = f;
  fgrseq_ = false;
}

Sequence::Sequence(RandomSequence rseq)
{
  start_ = 0.;
  step_ = 1.;
  myf_ = NULL;  
  rseq_ = rseq;
  fgrseq_ = true;
}

double Sequence::operator () (uint_4 k)
{
  if (fgrseq_) return(rseq_.Rand());
  else {
    double x = start_+(double)k*step_;
    if (myf_)  return(myf_(x));
    else return x;
  }
}

Range::Range(uint_4 start, uint_4 end, uint_4 size, uint_4 step)
{
  start_ = start;
  step_ = (step > 0) ? step : 1;
  if (end > start) {  // Taille calcule automatiquement 
    end_ = end;
    if (step_ > ((end_-start_)+1))  size_ = 1;
    else size_ = ((end-start)+1)/step_;
  }
  else {     // Taille fixee
    size_ = size;
    end_ = start_+size_*step_;
  }
}

/*
Range & Range::operator = (uint_4 start)
{
  start_ = start;
  size_ = 1;
  step_ = 1;
  return (*this);
}
*/


IdentityMatrix::IdentityMatrix(double diag, uint_4 n)
{
  size_ = n;
  diag_ = diag;
}
