// This may look like C code, but it is really -*- C++ -*-
//     Utility classes for template numerical arrays 
//                     R. Ansari, C.Magneville   03/2000

#ifndef UtilArray_SEEN
#define UtilArray_SEEN

#include "machdefs.h"
#include <stdlib.h>

namespace SOPHYA {   

/* Quelques utilitaires pour les tableaux (Array) */             

typedef double (* Arr_DoubleFunctionOfX) (double x);
typedef float  (* Arr_FloatFunctionOfX)  (float x);

class RandomSequence {
public:
  enum { Gaussian = 0, Flat = 1 };
  RandomSequence(int typ = RandomSequence::Gaussian, double m=0., double s=1.);
  double Rand();
protected:
  int typ_;
  double mean_, sig_;
};


class Sequence {
public:
  explicit Sequence (double start=0., double step=1., Arr_DoubleFunctionOfX f=NULL);
  explicit Sequence (RandomSequence rseq);
  inline double & Start() { return start_; }
  inline double & Step() { return step_; }
  double operator () (uint_4 k);
protected:
  double start_, step_;
  Arr_DoubleFunctionOfX myf_;
  bool fgrseq_;
  RandomSequence rseq_; 
};

class Range {
public:
  explicit Range(uint_4 start=0, uint_4 end=0, uint_4 size=1, uint_4 step=1);
  inline uint_4 & Start()  {  return start_; }
  inline uint_4 & End()    {  return end_; }
  inline uint_4 & Size()   {  return size_; }
  inline uint_4 & Step()   {  return step_; }
protected:
  uint_4 start_, end_, size_, step_ ;
};

class IdentityMatrix {
public:
  explicit IdentityMatrix(double diag=1., uint_4 n=0);
  inline uint_4 Size() { return size_; }
  inline double Diag() { return diag_; }
protected:
  uint_4 size_;
  double diag_;
};

} // Fin du namespace

#endif

