// This may look like C code, but it is really -*- C++ -*-
//  Classes image typee      E.Aubourg , E. Lesquoy     
//                           Modifs R. Ansari   04/95

// LAL (Orsay) / IN2P3-CNRS  DAPNIA/SPP (Saclay) / CEA

#ifndef CIMAGE_SEEN
#define CIMAGE_SEEN

#include <iostream.h>
#include <iomanip.h>
#include "rzimage.h"

// Flags de verifications sur les indices  dans rzimage.h 

//#define IMGRGCHECK
//#define IMGVOIDCHECK


// **********************************************************
// Classe Image


template <class T>
class Image : public RzImage {

public:
  Image(int sizx, int sizy, int zero=1);
  Image();
  Image(const Image<T>&, int sharePixels=0);
  Image(const Image<T>&, int orgx, int orgy, int sizx=-1, int sizy=-1);
  EXPLICIT Image(const RzImage&); // Pour Reza. Partage les pixels
  Image(char *flnm);
  virtual ~Image();

  static PPersist*      Create()              { return new Image<T>;}

  virtual void    ReadSelf(PInPersist&);

  Image<T>&       operator= (const Image<T> &);
  Image<T>&       operator= (T);

  Image<T>&       operator+= (Image<T> const&);
  Image<T>&       operator-= (Image<T> const&);
  Image<T>&       operator*= (Image<T> const&);
  Image<T>&       operator/= (Image<T> const&);

  Image<T>&       operator+= (double);
  Image<T>&       operator-= (double);
  Image<T>&       operator*= (double);
  Image<T>&       operator/= (double);

  Image<T>        WhereNonZero();


//   Impression de tout le contenu de l'image 
  virtual void    PrintImage(ostream& os) const;
  inline void     PrintImage() const  { PrintImage(cout); }

  void            Zero();
  void            Allocate(int sizx, int sizy, int zero=1, ImgVectP* pvpsh=NULL);

  inline T&       operator() (int x, int y);
  inline T        operator() (int x, int y) const;
  inline T&       operator[] (int i);
  inline T        operator[] (int i) const;
  T*              ImagePtr()         {return imagePtr;}
  const T*        ImagePtr() const   {return imagePtr;}
                                            
  int             CheckDyn(double min=-9.e19, double max=9.e19);

  void            SeuilBas(double seuil, double val);
  void            SeuilHaut(double seuil, double val);
  void            SeuilBas(double seuil);
  void            SeuilHaut(double seuil);
  void            SetPixels(int szx, int szy, T* pim);

  int EstimeFdSg(float& xbmax,float& sgbmax,float nbsig=3.5,float frac=0.33
                ,float lowbad=1.,float highbad=-1.,int deb=0);
  float FondCiel(int nbin,float bin_low,float bin_high
                ,int degre=2,float frac=0.5f,int modu=1,int deb=0);
  float SigmaCiel(int nbin,float bin_low,float bin_high,float& means
                 ,float lowbad=1.,float highbad=-1.
                 ,float nsig=4.f,int modu=1,int deb=0);
  int   MoySigma(float& mean,float& sigma
                ,float lowbad=1.,float highbad=-1.,int modu=1);
  int   MoySigmaIter(float& mean,float& sigma,float lowbad=1.,float highbad=-1.
                    ,int modu=1,int nitermx=10
                    ,float perdiff=0.1f,float scut=3.5f, int deb=0);
  int   FondSigmaCiel(float lowbad,float highbad,int pvsz=100
              ,float nbsig1=3.5f,float nbsig2=7.f,float nbsig3=5.f
              ,float binsg=0.5f,float frac=0.33f,int modu=1,int deb=0);


protected:

  void HBinInt(int& nbin,float& xmin,float& xmax);

  T*              imagePtr;
};

// Definition de l'operateur << 
//template <class T> 
//ostream& operator << (ostream& s, Image<T> const& img)
//  {  img.Print(s);  return(s);  }


/*  .......................................................  */
/*          Implementation inline des acces pixels           */
/*  .......................................................  */

// ----- Macro de verification des indices  ------ 

#ifdef IMGRGCHECK
#define CHECKIMG(_x_,_y_)                                  \
      if ((_x_ >= siz_x) || (_y_ >= siz_y) ||              \
          (_x_ < 0) || (_y_ < 0)) THROW(rangeCheckErr);  \
      if (!imagePtr) THROW(nullPtrErr)
#else
#if defined(IMGVOIDCHECK)
#define CHECKIMG(_x_,_y_) \
      if (!imagePtr) THROW(NullPtrErr)
#else
#define CHECKIMG(_x_,_y_)
#endif
#endif /* IMGRGCHECK */

#define INRANGE(_x_,_y_) ((_x_ < siz_x) && (_y_ < siz_y) && \
                          (_x_ >= 0) && (_y_ >= 0))


// Fin des macros  ------ 


template <class T>
inline T & Image<T>::operator() (int x, int y)
{
  CHECKIMG(x,y);
  return imagePtr[x+y*siz_x];
}

template <class T>
inline T Image<T>::operator() (int x, int y) const
{
  CHECKIMG(x,y);
  return imagePtr[x+y*siz_x];
}

template <class T>
inline T & Image<T>::operator[] (int i)
{
  CHECKIMG(0,0);
  return imagePtr[i];
}

template <class T>
inline T Image<T>::operator[] (int i) const
{
  CHECKIMG(0,0);
  return imagePtr[i];
}

// Operateurs addition, multiplication, ... (+ - * / ) avec des doubles 

template <class T> 
Image<T> operator+ (Image<T> const& a, double b) 
{
  Image<T> c(a);
  c += b;
  return c;
}

template <class T> 
Image<T> operator- (Image<T> const& a, double b) 
{
  Image<T> c(a);
  c -= b;
  return c;
}

template <class T> 
Image<T> operator* (Image<T> const& a, double b) 
{
  Image<T> c(a);
  c *= b;
  return c;
}

template <class T> 
Image<T> operator/ (Image<T> const& a, double b) 
{
  Image<T> c(a);
  c /= b;
  return c;
}

// Operateurs addition, multiplication, ... (+ - * / ) entre images
template <class T> 
Image<T> operator+ (Image<T> const& a, Image<T> const& b)
{
  Image<T> c(a);
  c += b;
  return c;
}

template <class T> 
Image<T> operator- (Image<T> const& a, Image<T> const& b) 
{
  Image<T> c(a);
  c -= b;
  return c;
}

template <class T> 
Image<T> operator* (Image<T> const& a, Image<T> const& b) 
{
  Image<T> c(a);
  c *= b;
  return c;
}

template <class T> 
Image<T> operator/ (Image<T> const& a, Image<T> const& b) 
{
  Image<T> c(a);
  c /= b;
  return c;
}

/*  .......................................................  */
/*         Fonctions de copie d'images et de paves           */
/*  .......................................................  */

template <class T2, class T1>
void CopieImageF(Image<T2>& copie, Image<T1> const& pim,
                 int org_pim_x=0, int org_pim_y=0,
                 int pim_lpav_x=0, int pim_lpav_y=0,
                 int org_copie_x=0, int org_copie_y=0,
                 double cutmin=0., double cutmax=0.);
                
template <class T2, class T1>
void CopieImage(Image<T2>& copie, Image<T1> const& pim);

template <class T2, class T1>
void CopieImage(Image<T2>& copie, Image<T1> const& pim,
                int org_pim_x, int org_pim_y,
                int pim_lpav_x=0, int pim_lpav_y=0,
                int org_copie_x=0, int org_copie_y=0,
                double cutmin=0, double cutmax=0);


template <class T2, class T1>
void 
CopiePave(Image<T2>& pave, Image<T1> const& pim,
	  float xc, float yc, 
	  double cutmin=0, double cutmax=0);


template <class T>
void 
RzCopieImage(Image<T>& copie, RzImage const& pim,
	     int org_pim_x, int org_pim_y,
	     int pim_lpav_x=0, int pim_lpav_y=0,
	     int org_copie_x=0, int org_copie_y=0,
	     double cutmin=0, double cutmax=0);

template <class T>
void 
RzCopieImage(Image<T>& copie, RzImage const& pim);

template <class T>
void 
RzCopiePave(Image<T> & pave, RzImage const & pim,
	    float xc, float yc,
	    double cutmin=0, double cutmax=0);
/*  .......................................................  */
/*         Autres fonctions utilitaires pour RzImage         */
/*  .......................................................  */

void RzPrintImage(RzImage & img);

/*  Images de types usuels   */

typedef Image<uint_1> ImageU1;
typedef Image<uint_2> ImageU2;
typedef Image<int_2>  ImageI2;
typedef Image<int_4>  ImageI4;
typedef Image<r_4>    ImageR4;


#ifdef __MWERKS__
template <class T>
ostream& operator << (ostream& s, Image<T> const& pim);
#endif

#endif


