// Classe d'initialisation du module Outils++ 
#include "machdefs.h"
#include "skymapinit.h" 

#include <unistd.h>
#include "spherethetaphi.h"
#include "fiospherehealpix.h"
#include "fiospherethetaphi.h"
#include "fiolocalmap.h"
#include "localmap.h"
 
int SkyMapInitiator::FgInit = 0;

SkyMapInitiator::SkyMapInitiator()
  : SophyaInitiator()
{
  FgInit++;
  if (FgInit > 1)  return;

//   Enregistrement des classes PPersist du module SkyMap
  
  PPRegister(FIO_SphereCoordSys);
  DObjRegister(FIO_SphereCoordSys, SphereCoordSys);

  PPRegister(FIO_SphereThetaPhi<r_4>);
  DObjRegister(FIO_SphereThetaPhi<r_4>, SphereThetaPhi<r_4>);

  PPRegister(FIO_SphereThetaPhi<r_8>);
  DObjRegister(FIO_SphereThetaPhi<r_8>, SphereThetaPhi<r_8>);

  PPRegister(FIO_SphereThetaPhi< complex<r_4> >);
  DObjRegister(FIO_SphereThetaPhi< complex<r_4> >, SphereThetaPhi< complex<r_4> >);

  PPRegister(FIO_SphereThetaPhi< complex<r_8> >);
  DObjRegister(FIO_SphereThetaPhi< complex<r_8> >, SphereThetaPhi< complex<r_8> >);

  PPRegister(FIO_SphereHEALPix<r_4>);  
  DObjRegister(FIO_SphereHEALPix<r_4>, SphereHEALPix<r_4>);

  PPRegister(FIO_SphereHEALPix<r_8>);
  DObjRegister(FIO_SphereHEALPix<r_8>, SphereHEALPix<r_8>);

  PPRegister(FIO_SphereHEALPix< complex<r_4> >);
  DObjRegister(FIO_SphereHEALPix< complex<r_4> >, SphereHEALPix< complex<r_4> >);

  PPRegister(FIO_SphereHEALPix< complex<r_8> >);
  DObjRegister(FIO_SphereHEALPix< complex<r_8> >, SphereHEALPix< complex<r_8> >);

  PPRegister(FIO_LocalMap<r_4>);
  DObjRegister(FIO_LocalMap<r_4>, LocalMap<r_4>);

  PPRegister(FIO_LocalMap<r_8>);
  DObjRegister(FIO_LocalMap<r_8>, LocalMap<r_8>);

  PPRegister(FIO_LocalMap< complex<r_4> >);
  DObjRegister(FIO_LocalMap< complex<r_4> >, LocalMap< complex<r_4> >);

  PPRegister(FIO_LocalMap< complex<r_8> >);
  DObjRegister(FIO_LocalMap< complex<r_8> >, LocalMap< complex<r_8> >);


}

SkyMapInitiator::~SkyMapInitiator()
{
  FgInit--;
}


// On met un objet initiator en statique, pour les loaders qui savent 
// appeler le constructeur des objets statiques   Reza 08/98
static SkyMapInitiator s_sskymapinit_;

 
