// This may look like C code, but it is really -*- C++ -*-
/*! Class for inferior triangular matrix (base class for the class Alm) */

#ifndef TRIANGMTX_H_SEEN
#define TRIANGMTX_H_SEEN

#include "ndatablock.h"
#include "pexceptions.h"

namespace SOPHYA {

template <class T>
class TriangularMatrix 
  {
    
  public :

TriangularMatrix()   {};
  /* instanciate a triangular matrix from the number of rows */
TriangularMatrix(int rowSize)  : long_diag_((uint_4)rowSize) {elem_.ReSize((uint_4) (rowSize*(rowSize+1)/2) ); };
TriangularMatrix(const TriangularMatrix<T>& a,  bool share=false)  : elem_(a.elem_, share),  long_diag_(a.long_diag_) {;}
/*! resize the matrix with a new number of rows */
inline void ReSizeRow(int rowSize) 
  {
    long_diag_=(uint_4)rowSize;
    elem_.ReSize(long_diag_*(long_diag_+1)/2);
  }
 inline void SetTemp(bool temp=false) const {elem_.SetTemp(temp);}

inline TriangularMatrix<T>& operator = (const TriangularMatrix<T>& a)
{
  elem_=a.elem_;
  long_diag_ = a.long_diag_;
  return *this;
}
inline T& operator()(int l, int m) 
  {
      return  elem_(adr_ij(l,m));
  }
inline T const& operator()(int l, int m) const 
  {
      return *(elem_.Begin()+ adr_ij(l,m));
  }
 inline  int_4  rowNumber() const {return (int_4)long_diag_;}
  private: 
 /*! compute the address of an element in the single array representing the matrix */
inline uint_4 adr_ij(int i,int j) const 
{
  int adr= i*(i+1)/2+j;
  //  if ( adr >= elem_.Size() || adr <0 )
  //{
  // cout << " attention depassement dans triangularMatrix " << endl;
  // cout << " l= " << i << " m= " << j << " tableau reserve longueur " << elem_.Size() << endl; 
  //}
  return(i*(i+1)/2+j);
}

 uint_4 long_diag_;
 NDataBlock<T> elem_;

  };

}   // namespace SOPHYA

#endif
