#include "fitsfile.h"
#include "pexceptions.h"
#include "strutil.h"
 

FitsFile::FitsFile() 
{
  fptr_= NULL; 
  hdutype_= 0;
  hdunum_ = 0; 

  nrows_ = 0;
}

 
FitsFile::~FitsFile()
{
  int status = 0;
  if( fptr_ != NULL) fits_close_file(fptr_,&status);
  if( status )  printerror( status );
}
void FitsFile::ReadF(char flnm[],int hdunum) 
{
  int status = 0;
  hdutype_= 0;
  hdunum_ = 0; 
  fits_open_file(&fptr_,flnm,READONLY,&status);
  if( status ) printerror( status );

  // move to the specified HDU number
  int hdutype;
  fits_movabs_hdu(fptr_,hdunum,&hdutype,&status);
  if( status ) printerror( status );
  
  hdutype_= hdutype;
  hdunum_ = hdunum;
  if(hdutype_ == IMAGE_HDU) 
    {
      read_image();
    }
  if(hdutype_ == ASCII_TBL || hdutype_ == BINARY_TBL)
    {
      GetBinTabParameters();
    }
  ReadFromFits(*this);

} 
void FitsFile::WriteF(char flnm[],int hdunum)
{
  int status = 0; 
  hdutype_= 0;
  hdunum_ = hdunum; 
  // create new FITS file
  fits_create_file(&fptr_,flnm,&status);
  if( status ) printerror(status,"file already exists");
  WriteToFits(*this);
}
void FitsFile::GetSingleColumn(double* map, int nentries) const
{ 
  int status = 0;
  if(hdutype_ == IMAGE_HDU) 
    {
  
      if(bitpix_ != DOUBLE_IMG) 
	{
	  cout << " The data type on fits file is not double...";
	  cout << " Conversion to double achieved by cfitsio lib" << endl;
	}
  
      // no checking for undefined pixels
      int    anull;
      double dnull= 0.;
  
      long nels= nentries;
      fits_read_img(fptr_,TDOUBLE,1,nels,&dnull,map,&anull,&status);
      if( status ) printerror( status );
    }
  else
    if(hdutype_ == ASCII_TBL || hdutype_ == BINARY_TBL)
      {
	GetBinTabFCol(map,nentries, 0);
      }
    else
      {
      cout << " hdutype= " << hdutype_ << endl;
      throw IOExc("FitsFile::GetSingleColumn this HDU is unknown");
      }
}

void FitsFile::GetSingleColumn(float* map, int nentries) const
{
  int status = 0;
  if(hdutype_ == IMAGE_HDU) 
    {
      if(bitpix_ != FLOAT_IMG) 
	{
	  cout << " The data type on fits file is not float ";
	  cout << " Conversion to float achieved by cfitsio lib" << endl;
	}
      // no checking for undefined pixels
      int   anull;
      float fnull= 0.;
      
      long nels= nentries;
      fits_read_img(fptr_,TFLOAT,1,nels,&fnull, map,&anull,&status);
      if( status ) printerror( status );
    }
  else
    if(hdutype_ == ASCII_TBL || hdutype_ == BINARY_TBL)
      {
	GetBinTabFCol(map,nentries, 0);
      }
    else
      {
      cout << " hdutype= " << hdutype_ << endl;
      throw IOExc("FitsFile::GetSingleColumn this HDU is unknown");
      }
}

void FitsFile::GetSingleColumn( int* map, int nentries) const
{
  int status = 0;
  if(hdutype_ == IMAGE_HDU) 
    {
      if(bitpix_ != LONG_IMG) 
	{
	  cout << " The data type on fits file is not int ";
	  cout << " Conversion to float achieved by cfitsio lib" << endl;
	}
      // no checking for undefined pixels
      int   anull;
      float fnull= 0.;
      
      long nels= nentries;
      fits_read_img(fptr_,TINT,1,nels,&fnull,map,&anull,&status);
      if( status ) printerror( status );
    }
  else
    if(hdutype_ == ASCII_TBL || hdutype_ == BINARY_TBL)
      {
	GetBinTabFCol(map,nentries, 0);
      }
    else
      {
      cout << " hdutype= " << hdutype_ << endl;
      throw IOExc("FitsFile::GetSingleColumn this HDU is unknown");
      }
}
void FitsFile::makeHeaderImageOnFits(char type, int nbdim, int* naxisn) const
{
  int status = 0;
  long naxis = nbdim;
  long* naxes = new long[nbdim];
  for (int k=0; k< nbdim; k++) naxes[k] = (long)naxisn[k];
  if (type == 'D')
    fits_create_img(fptr_,DOUBLE_IMG,naxis,naxes,&status);
  else
    if  (type == 'E')
      fits_create_img(fptr_,FLOAT_IMG,naxis,naxes,&status);
    else
      if  (type == 'I')
	fits_create_img(fptr_,LONG_IMG,naxis,naxes,&status);
      else
	{
	  cout << " type of data: " << type << endl;
	  throw PException("FitsFile:::makeHeaderImageOnFits:unprogrammed type of data ");
	}
  delete [] naxes;
  if( status ) printerror( status );

}
void FitsFile::putImageToFits(int nbData, double* map) const
{
  int status = 0;
  long npix= nbData;
  fits_write_img(fptr_,TDOUBLE,1,npix,map,&status); 
  if( status ) printerror( status );
  writeSignatureOnFits();
}

void FitsFile::putImageToFits(int nbData, float* map) const
{
  int status = 0;
  long npix= nbData;
  fits_write_img(fptr_,TFLOAT,1,npix, map,&status); 
  if( status ) printerror( status );
  writeSignatureOnFits();

}
void FitsFile::putImageToFits( int nbData, int* map) const
{
  int status = 0;

  long npix= nbData;
  fits_write_img(fptr_,TINT,1,npix,map,&status); 
  if( status ) printerror( status );
  writeSignatureOnFits();
}


void FitsFile::read_image()
{
  cout << " Reading a FITS image in HDU : " << hdunum_ << endl;
  int status= 0;

  // bits per pixels
  fits_read_key(fptr_,TINT,"BITPIX",&bitpix_,NULL,&status);
  if( status )  printerror( status );

  // number of dimensions in the FITS array
  int naxis= 0;
  fits_read_key(fptr_,TINT,"NAXIS",&naxis,NULL,&status);
  if( status ) printerror( status );
  naxis_ = naxis;

  // read the NAXIS1 and NAXIS2 keyword to get image size
  long* naxes = new long[naxis_] ;
  int nfound;
  fits_read_keys_lng(fptr_,"NAXIS",1,naxis_,naxes,&nfound,&status);
  if( status ) printerror( status );
  if (nfound != naxis_ ) 
    cout << " WARNING : " << nfound << " axes found, expexted naxis= " << naxis_ << endl;
  int lastSize = naxes[naxis_-1]; 
  while (lastSize <= 1) 
    {
      naxis_--;
      lastSize = naxes[naxis_-1];
    }

  nbData_ =  1;
  for (int k=0; k<naxis_; k++) 
    {
      naxisn_.push_back( (int)naxes[k] );
      if (naxisn_[k] > 0) nbData_ *= naxisn_[k];

    }
  delete [] naxes;
}

 
  void FitsFile::GetBinTabFCol(double* valeurs,int nentries, int NoCol) const
    {
      int status= 0;
      int DTYPE;
      long repeat,width;
            fits_get_coltype(fptr_, NoCol+1,&DTYPE,&repeat,&width,&status);
      if( DTYPE != TDOUBLE) 
	{
	  throw IOExc("FitsFile::GetBinTabFCol, tentative de lecture non double");
	}
      long nels=nentries;
      // no checking for undefined pixels
      int    anull;
      float dnull= 0.;
      fits_read_col(fptr_,TDOUBLE,NoCol+1,1,1,nels,&dnull,valeurs,
			    &anull,&status);
      if( status ) printerror( status,"erreur lecture de colonne" );
    }

  void FitsFile::GetBinTabFCol(float* valeurs,int nentries, int NoCol) const
    {
      int status= 0;
      int DTYPE;
      long repeat,width;
      fits_get_coltype(fptr_, NoCol+1,&DTYPE,&repeat,&width,&status);
      if( DTYPE != TFLOAT) 
	{
	  throw IOExc("FitsFile::GetBinTabFCol, tentative de lecture non float");
	}
      long nels=nentries;
      // no checking for undefined pixels
      int    anull;
      float fnull= 0.;
      fits_read_col(fptr_,TFLOAT,NoCol+1,1,1,nels,&fnull,valeurs,
			    &anull,&status);
      if( status ) printerror( status,"erreur lecture de colonne" );
    }
  void FitsFile::GetBinTabFCol(int* valeurs,int nentries, int NoCol) const
    {
      int status= 0;
      int DTYPE;
      long repeat,width;
      fits_get_coltype(fptr_, NoCol+1,&DTYPE,&repeat,&width,&status);
      if( DTYPE != TLONG &&  DTYPE != TINT &&  DTYPE != TSHORT ) 
	{
	  throw IOExc("FitsFile::GetBinTabFCol, tentative de lecture non entier");
	}
      long nels=nentries;
      // no checking for undefined pixels
      int    anull;
      int inull= 0;
      fits_read_col(fptr_,TINT,NoCol+1,1,1,nels,&inull,valeurs,
			    &anull,&status);
      if( status ) printerror( status,"erreur lecture de colonne" );
    }
  void FitsFile::GetBinTabFCol(char** valeurs, int nentries, int NoCol) const
    {
      int status= 0;
      int DTYPE;
      long repeat,width;
      fits_get_coltype(fptr_, NoCol+1,&DTYPE,&repeat,&width,&status);
      if( DTYPE != TSTRING ) 
	{
	  throw IOExc("FitsFile::GetBinTabFCol, tentative de lecture non float");
	}
      long nels=nentries;
      // no checking for undefined pixels
      int    anull;
      char* cnull= " ";
      long frow=1;
      long felem=1;
      fits_read_col(fptr_,TSTRING,NoCol+1,frow,felem,nels,cnull,valeurs,
		    &anull,&status);
      if( status ) printerror( status,"erreur lecture de colonne" );
    }
int  FitsFile::NbColsFromFits() const
{
  int status= 0;
  if(hdutype_ ==  BINARY_TBL) return nbcols_;
  else
    if(hdutype_ == ASCII_TBL ||  hdutype_ == IMAGE_HDU) return 1;
    else
      {
	cout << " hdutype= " << hdutype_ << endl;
	throw PException("FitsFile::NbColsFromFits, this HDU is unknown");
      }
}

char FitsFile::ColTypeFromFits(int nocol) const
{
  int status= 0;
  if(hdutype_ != ASCII_TBL && hdutype_ != BINARY_TBL)
    {
      throw IOExc("FitsFile::TypeFromFits, this HDU is not an ASCII table nor a binary table");
    }
  return types_[nocol];
}
int FitsFile::NentriesFromFits(int nocol) const
{
  int status= 0;
  if(hdutype_ == BINARY_TBL  )   return nrows_*repeat_[nocol];
  else
    if(hdutype_ == ASCII_TBL) return nrows_;
    else
      if(hdutype_ == IMAGE_HDU) return nbData_;
      else
	{
	  cout << "hdutype= " << hdutype_ << endl;
	  throw PException("FitsFile::NentriesFromFits, this HDU is unknown");
	}
}

string FitsFile::ColNameFromFits(int nocol) const
{
  int status= 0;
  if(hdutype_ != ASCII_TBL && hdutype_ != BINARY_TBL)
    {
      throw IOExc("FitsFile::TypeFromFits, this HDU is not an ASCII table nor a binary table");
    }
  return noms_[nocol];
}
int FitsFile::ColStringLengthFromFits(int nocol) const
{
  int status= 0;
  if(hdutype_ != ASCII_TBL && hdutype_ != BINARY_TBL)
    {
      throw IOExc("FitsFile::TypeFromFits, this HDU is not an ASCII table nor a binary table");
    }
  int index=-1;
  for (int k=0; k<=nocol; k++) 
    {
      if (types_[k] == 'S') index++;
    }
  return  taille_des_chaines_[index];
}

void FitsFile::GetBinTabParameters()
{
  int status= 0;
  if(hdutype_ != ASCII_TBL && hdutype_ != BINARY_TBL)
    {
      throw IOExc("FitsFile:: this HDU is not an ASCII table nor a binary table");
    }
  if(hdutype_ == ASCII_TBL)
    cout << " Reading a FITS ascii table in HDU : " << hdunum_ << endl;  
  if(hdutype_ == BINARY_TBL)
    cout << " Reading a FITS binary table in HDU : " << hdunum_ << endl;

  // get the number of columns
  int nbcols = 0;
  fits_get_num_cols(fptr_, &nbcols,&status);
  if( status ) printerror( status );
  nbcols_=nbcols;

  // get the number of rows
  long naxis2= 0;
  fits_get_num_rows(fptr_,&naxis2,&status);
  if( status ) printerror( status );
  nrows_= (int)naxis2;

  // get the datatype,  names and the repeat count
  noms_.clear();
  noms_.reserve(nbcols);
  types_.clear();
  types_.reserve(nbcols);
  repeat_.clear();
  repeat_.reserve(nbcols);
  taille_des_chaines_.clear();
  char **ttype = new char*[nbcols];
  for (int ii=0; ii < nbcols; ii++) ttype[ii]=new char[FLEN_VALUE];
  int nfound;
  fits_read_keys_str(fptr_, "TTYPE",1,nbcols,ttype,&nfound, &status);
  if( status ) printerror( status,"erreur lecture des noms de colonne");
  //  int nentries = nrows_;
  int rept=0;
  for(int ii = 0; ii <  nbcols; ii++)
    {
      int DTYPE;
      long width;
      long repeat = 0;
      fits_get_coltype(fptr_,ii+1,&DTYPE,&repeat,&width,&status);
      if( status ) printerror( status,"erreur lecture type de colonne");
      rept = repeat;
      noms_.push_back(string(ttype[ii]));
      //      cout << " getparam: nentries= " << nentries << " rept= " << rept << endl;
      switch (DTYPE)
	{
	case TDOUBLE :
	  types_.push_back('D');
	  break;
	case TFLOAT :
	  types_.push_back('E');
	  break;
	case TLONG :
	  types_.push_back('I');
	  break;
	case TINT :
	  types_.push_back('I');
	  break;
	case TSHORT :
	  types_.push_back('I');
	  break;
	case TSTRING :
	  types_.push_back('S');
	  taille_des_chaines_.push_back(width);
	  rept/=width;
	  break;
	default :
	  cout << " field " << ii+1 << " DTYPE= " << DTYPE << endl;
	  throw IOExc("FitsFile:: unknown type of field");
	}
      //    nentries = max(nentries, nrows_*rept);
      repeat_.push_back(rept);
    } 
  // get number of keywords
  int nkeys,keypos;
  fits_get_hdrpos(fptr_,&nkeys,&keypos,&status);
  if( status ) printerror( status );

  // put  keywords in a DVList object
  char keyname[LEN_KEYWORD]= "";
  char strval[FLEN_VALUE]= "";
  char dtype;
  char card[FLEN_CARD];  
  char *comkey = "COMMENT";

  // shift with the number of mandatory keywords
  int num= 8;

  for(int j = num+1; j <= nkeys; j++)
    {
      fits_read_keyn(fptr_,j,card,strval,NULL,&status);
      if(status) printerror(status);

      strncpy(keyname,card,LEN_KEYWORD-1);
      
      if(strncmp(keyname,comkey,LEN_KEYWORD-1) != 0 && strlen(keyname) != 0 
	 && strlen(strval) != 0)
	{
	  fits_get_keytype(strval,&dtype,&status);
	  if(status)  printerror(status);
	  
	  strip(keyname, 'B',' '); 
	  strip(strval, 'B',' ');
	  strip(strval, 'B','\'');
	  
	  switch( dtype )  
	    { 
	    case 'C':
	      dvl_[keyname]= strval;	  
	      break;
	    case 'I':
	      int ival;
	      fits_read_key(fptr_,TINT,keyname,&ival,NULL,&status);
	        dvl_[keyname]= (int_4) ival;		// Portage mac DY
	      break;
	    case 'L':
	      int ilog;
	      if(strncmp(strval,"T",1) == 0) ilog= 1;
	      else ilog= 0;
	      dvl_[keyname]= (int_4) ilog;
	      break;
	    case 'F':
	      double dval;
	      fits_read_key(fptr_,TDOUBLE,keyname,&dval,NULL,&status);
	      dvl_[keyname]= dval;
	      break;
	    }
	  
	}
    } 
  //  dvl_.Print();
}
void FitsFile::makeHeaderBntblOnFits( char* fieldType, char** Noms, int nentries, int tfields, DVList &dvl, char* extname, vector<int> taille_des_chaines) const
{ 
  int status = 0;
  long nrows;
  if (strlen(fieldType) != tfields)
    {
      cout << " nombre de champs :" << tfields << "nombre de types: " << strlen(fieldType) << endl;
	      throw ParmError("FitsFile:: fields and types don't match");

    }
  char ** ttype= new char*[tfields];
  char ** tform= new char*[tfields];
  char largeur[FLEN_VALUE];
  int noColString=0;


  for (int k=0; k<tfields;k++)
    {
      char  format[FLEN_VALUE];
      
      if(nentries < 1024) 
	{
	  nrows= nentries;
	  if (fieldType[k] == 'A')
	    {
	      sprintf(largeur,"%d",taille_des_chaines[noColString++]);
	      strcpy(format,largeur);
	    }
	  else strcpy(format,"1");
	}
      else
	{
	  nrows = nentries/1024;
	  if(nentries%1024 != 0) nrows++;
	  if (fieldType[k] == 'A') 
	    {
	    char largaux[FLEN_VALUE];
	    sprintf(largeur,"%d",taille_des_chaines[noColString]);
	    sprintf(largaux,"%d",1024*taille_des_chaines[noColString]);
	    noColString++;
	    strcpy(format, largaux);    
	    }
	  else strcpy(format,"1024");
	}
      strncat(format,&fieldType[k],1);
      if (fieldType[k] == 'A') 
	{
	  strcat(format,largeur);
	}
      ttype[k]= new char[FLEN_VALUE];
      strcpy(ttype[k],Noms[k]);
      tform[k]= new char[FLEN_VALUE];
      strcpy(tform[k],format);
    }
  const char* TypeOfContent= dvl.GetS("TypeOfContent").c_str();
  // value of the EXTNAME keyword
  char extn[FLEN_VALUE];
  strncpy(extn,extname,FLEN_VALUE);

  // create a new empty binary table onto the FITS file
  // physical units if they exist, are defined in the DVList object
  // so the NULL pointer is given for the tunit parameters.
  nrows=0;
  fits_create_tbl(fptr_,BINARY_TBL,nrows,tfields,ttype,tform,
		  NULL,extn,&status);
  if( status ) printerror( status );

  for(int ii = 0; ii < tfields; ii++)
    {
      delete [] ttype[ii];
      delete [] tform[ii];
    }
  delete [] ttype;
  delete [] tform;
  //
  // write supplementary keywords
  //
  // get names and values from the join DVList object
  //  dvl.Print();
  DVList::ValList::const_iterator it;
  for(it = dvl.Begin(); it != dvl.End(); it++)
    {
      char keytype= (*it).second.elval.typ;
      char keyname[10];
      strncpy(keyname,(*it).first.substr(0,64).c_str(),10);
      char comment[FLEN_COMMENT];
      switch (keytype)
	{
	case 'I' :
	  {
	    int ival=(*it).second.elval.mtv.iv;
	    strcpy(comment,"I entier");
	    fits_write_key(fptr_,TINT,keyname,&ival,comment,&status);
	    break;
	  }
	case 'D' :
	  {
	    double dval=(*it).second.elval.mtv.dv;
	    strcpy(comment,"D double");
	    fits_write_key(fptr_,TDOUBLE,keyname,&dval,comment,&status);
	    break;
	  }
	case 'S' :
	  {
	    char strval[128];
	    strncpy(strval,(*it).second.elval.mtv.strv,127);
	    strcpy(comment,"S character string");
	    fits_write_key(fptr_,TSTRING,keyname,&strval,comment,&status);
	    break;
	  }
	} 
  if( status )  printerror( status,"fitsfile: probleme ecriture mot-cle du dvlist" );
    }

}

void FitsFile::putColToFits(int nocol, int nentries, double* donnees) const
{
  int status = 0;
  int hdutype, hdunum;
  fits_movabs_hdu(fptr_,hdunum_,&hdutype,&status);
  if( status ) printerror(status,"putColToFits: le movabs a foire");
  fits_get_hdu_type(fptr_, &hdutype, &status);
    if(hdutype != ASCII_TBL && hdutype != BINARY_TBL)
        {
            cout << " hdunum= " << hdunum_ << " hdutype= " << hdutype << endl;
     throw IOExc("FitsFile::putColToFits, this HDU is not an ASCII table nor a binary table");
          }
  //  if(hdutype == ASCII_TBL && nocol>0)
  //  {
  //   throw IOExc("FitsFile::putColToFits, this HDU is an ASCII table, nocol>0  forbidden");
  //  }
  int code; 
  long repeat, width;
  fits_get_coltype(fptr_, nocol+1, &code, &repeat,&width, &status);
  if( code != TDOUBLE)
    {
      cout << " WARNING : types don't match (putColToFits) : on fits file= " << code << " to be written= DOUBLE " << endl;
    } 
  fits_write_col(fptr_,TDOUBLE,nocol+1,1,1,nentries, donnees ,&status);
  if( status )  printerror( status,"erreur ecriture du fichier fits" );
}
void FitsFile::putColToFits(int nocol, int nentries, float* donnees) const
{
  int status = 0;
  int hdutype;
  fits_movabs_hdu(fptr_,hdunum_,&hdutype,&status);
  if( status ) printerror(status,"putColToFits: le movabs a foire");
  fits_get_hdu_type(fptr_, &hdutype, &status);
  if(hdutype != ASCII_TBL && hdutype != BINARY_TBL)
    {
      cout << " hdunum= " << hdunum_ << " hdutype= " << hdutype << endl;
      throw IOExc("FitsFile::putColToFits, this HDU is not an ASCII table nor a binary table");
    }
  if(hdutype == ASCII_TBL && nocol>0)
    {
      throw IOExc("FitsFile::putColToFits, this HDU is an ASCII table, nocol>0  forbidden");
    }
  int code; 
  long repeat, width;
  fits_get_coltype(fptr_, nocol+1, &code, &repeat,&width, &status);
  if( code != TFLOAT)
    {
      cout << " WARNING : types don't match (putColToFits) : on fits file= " << code << " (FITS code), to be written= FLOAT " << endl;
    } 
  fits_write_col(fptr_,TFLOAT,nocol+1,1,1,nentries, donnees ,&status);
  if( status )  printerror( status,"erreur ecriture du fichier fits" );
}
void FitsFile::putColToFits(int nocol, int nentries, int* donnees) const
{
  int status = 0;
  int hdutype;
  fits_movabs_hdu(fptr_,hdunum_,&hdutype,&status);
  if( status ) printerror(status,"putColToFits: le movabs a foire");
  fits_get_hdu_type(fptr_, &hdutype, &status);
  if(hdutype != ASCII_TBL && hdutype != BINARY_TBL)
    {
      cout << " hdunum= " << hdunum_ << " hdutype= " << hdutype << endl;
      throw IOExc("FitsFile::putColToFits, this HDU is not an ASCII table nor a binary table");
    }
  if(hdutype == ASCII_TBL && nocol>0)
    {
      throw IOExc("FitsFile::putColToFits, this HDU is an ASCII table, nocol>0  forbidden");
    }
  int code; 
  long repeat, width;
  fits_get_coltype(fptr_, nocol+1, &code, &repeat,&width, &status);
  if( code != TLONG &&  code != TINT &&  code != TSHORT ) 
    {
      cout << " WARNING : types don't match (putColToFits) : on fits file= " << code << " (FITS code), to be written= FLOAT " << endl;
    } 
  fits_write_col(fptr_,TINT,nocol+1,1,1,nentries, donnees ,&status);
  if( status )  printerror( status,"erreur ecriture du fichier fits" );
}
void FitsFile::putColToFits(int nocol, int nentries, char** donnees) const
{
  int status = 0;
  int hdutype;
  fits_movabs_hdu(fptr_,hdunum_,&hdutype,&status);
  if( status ) printerror(status,"putColToFits: le movabs a foire");
  fits_get_hdu_type(fptr_, &hdutype, &status);
  if(hdutype != ASCII_TBL && hdutype != BINARY_TBL)
    {
      cout << " hdunum= " << hdunum_ << " hdutype= " << hdutype << endl;
      throw IOExc("FitsFile::putColToFits, this HDU is not an ASCII table nor a binary table");
    }
  if(hdutype == ASCII_TBL && nocol>0)
    {
      throw IOExc("FitsFile::putColToFits, this HDU is an ASCII table, nocol>0  forbidden");
    }
  int code; 
  long repeat, width;
  fits_get_coltype(fptr_, nocol+1, &code, &repeat,&width, &status);
  if( code != TSTRING)
    {
      cout << " WARNING : types don't match (putColToFits) : on fits file= " << code << " (FITS code), to be written= char** " << endl;
    } 
  fits_write_col(fptr_,TSTRING,nocol+1,1,1,nentries, donnees ,&status);
  if( status )  printerror( status,"erreur ecriture du fichier fits" );
}




void FitsFile::readheader()
  //*************************************/
  //* Print out all the header keywords */
  //*************************************/
{
  // standard string lengths defined in fitsioc.h
  char card[FLEN_CARD];

  int status = 0;

  // get the number of keywords
  int nkeys, keypos;
  if( fits_get_hdrpos(fptr_,&nkeys,&keypos,&status) )
    printerror( status );

  cout << " Header listing for HDU : " << hdunum_ << endl;
  for(int jj = 1; jj <= nkeys; jj++)  
    {
      if( fits_read_record(fptr_,jj,card,&status) )
	printerror( status );
      
      // print the keyword card
      cout << card << endl; 
    }
  cout << "END" << endl;
}


void FitsFile::writeSignatureOnFits() const
{
  int status = 0;
  char keyname[LEN_KEYWORD];
  char strval[FLEN_VALUE];
  char comment[FLEN_COMMENT];
  
  strcpy(keyname,"CREATOR");
  strcpy(strval,"SOPHYA");
  strcpy(comment,"SOPHYA Package - FitsFile");
  fits_write_key(fptr_,TSTRING,keyname,&strval,comment,&status);
}

void FitsFile::printerror(int &status) const
  //*****************************************************/
  //* Print out cfitsio error messages and exit program */
  //*****************************************************/
{
  if( status )
    {
      fits_report_error(stderr,status);
      throw IOExc("FitsFile:: error FITSIO status");
    }
  return;
}

void FitsFile::printerror(int& status, char* texte) const
  //*****************************************************/
  //* Print out cfitsio error messages and exit program */
  //*****************************************************/
{
  // print out cfitsio error messages and exit program 
  // print error report  
  fits_report_error(stderr, status);
  cout << " erreur:: " << texte << endl;
  throw IOExc("FitsFile:: error FITSIO status");
}
