#include "pexceptions.h"
#include "fitsxntuple.h"
///////////////////////////////////////////////////////////
//   Les objets delegues pour la gestion de persistance sur fichiers fits 
//    pout XNTuple
///////////////////////////////////////////////////////////


#define LONNOM 31 


FITS_XNTuple::FITS_XNTuple()
{
  dobj_ = new XNTuple;
  dcolumn_ = NULL;
  fcolumn_ = NULL;
  icolumn_ = NULL;
  ccolumn_ = NULL;
  ownobj=true;
}

FITS_XNTuple::FITS_XNTuple(char inputfile[],int hdunum)
{
  dobj_ = new XNTuple;
  dcolumn_ = NULL;
  fcolumn_ = NULL;
  icolumn_ = NULL;
  ccolumn_ = NULL;
  ownobj=true; 

  ReadF(inputfile,hdunum);
}


FITS_XNTuple::FITS_XNTuple(const XNTuple & obj) 
{ 
  dobj_ = new XNTuple(obj);
  dcolumn_ = NULL;
  fcolumn_ = NULL;
  icolumn_ = NULL;
  ccolumn_ = NULL;
  ownobj=true; 
}
FITS_XNTuple::~FITS_XNTuple()
{
  if (dcolumn_ != NULL) delete [] dcolumn_;
  if (fcolumn_ != NULL) delete [] fcolumn_;
  if (icolumn_ != NULL) delete [] icolumn_;
  if (ccolumn_ != NULL)
    {
      if (dobj_ != NULL)
	{
	  for (int k=0; k<dobj_->NEntry(); k++) delete [] ccolumn_[k];
	  delete [] ccolumn_;
	}
      else
	{
	  cout << "FITS_XNTuple, destructeur: bizarre, ccolumn non vide, sans objet?" << endl;;  	}
    }
  if (ownobj && dobj_ != NULL) delete dobj_;
}
void FITS_XNTuple::Write(char outputfile[],int hdunum)
{       
  WriteF(outputfile, hdunum);
} 
 
void FITS_XNTuple::ReadFromFits(const FitsFile& fn)
{   
  if (!fn.IsFitsTable())
    {
      throw PException("ReadFromFits: the fits file seems not to be a bintable nor ASCII table");
    }
  int nbcols, nbentries;
  nbcols = fn.NbColsFromFits();
  nbentries = 0;
  for (int k=0; k<nbcols; k++) nbentries=max( nbentries, fn.NentriesFromFits(k) );

  //
  // pour mettre les colonnes dans l'ordre double, float, int, char :
  // tableau de correspondance 
  // DfitsCol(j)= numero dans le fichier fits de la  jeme variable double du 
  // xntuple;
  // FfitsCol(j)= numero dans le fichier fits de la  jeme variable float du 
  // xntuple;
  // etc.
  vector<int> DfitsCol;
  vector<int> FfitsCol;
  vector<int> IfitsCol;
  vector<int> SfitsCol;
  for (int k=0; k<nbcols;k++)
    {
      char ss= fn.ColTypeFromFits(k);
      if (ss == 'D') DfitsCol.push_back(k);
      else if (ss == 'E') FfitsCol.push_back(k);
      else if (ss == 'I') IfitsCol.push_back(k);
      else if (ss == 'S') SfitsCol.push_back(k);
      else {
	cout << " FITS_XNTuple: colonne fits " << k << " type= " << ss << endl;
	throw  IOExc("type de champ inconnu");
      }
    }
  char ** ColName = new char*[nbcols];
  int compt=0;
  for (int k=0; k<DfitsCol.size(); k++)
    {
      ColName[compt] = new char[LONNOM+1]; 
      strncpy(ColName[compt], fn.ColNameFromFits(DfitsCol[k]).c_str(), LONNOM);
      ColName[compt++][ LONNOM] =  '\0';
    }
  for (int k=0; k<FfitsCol.size(); k++)
    {
      ColName[compt] = new char[LONNOM+1]; 
      strncpy(ColName[compt], fn.ColNameFromFits(FfitsCol[k]).c_str(), LONNOM);
      ColName[compt++][ LONNOM] =  '\0';
    }
  for (int k=0; k<IfitsCol.size(); k++)
    {
      ColName[compt] = new char[LONNOM+1]; 
      strncpy(ColName[compt], fn.ColNameFromFits(IfitsCol[k]).c_str(), LONNOM);
      ColName[compt++][ LONNOM] =  '\0';
    }
  for (int k=0; k<SfitsCol.size(); k++)
    {
      ColName[compt] = new char[LONNOM+1]; 
      strncpy(ColName[compt], fn.ColNameFromFits(SfitsCol[k]).c_str(), LONNOM);
      ColName[compt++][LONNOM] =  '\0';
    }


  if(dobj_ == NULL) 
    { 
      dobj_= new XNTuple(DfitsCol.size(), FfitsCol.size(), IfitsCol.size(), SfitsCol.size(),ColName);
      ownobj= true;      
    }
  else 
    {
      dobj_->clean();
      (*dobj_)= XNTuple(DfitsCol.size(), FfitsCol.size(), IfitsCol.size(), SfitsCol.size(),ColName);
    }
  for (int k=0; k<nbcols;k++) 
    {
      delete [] ColName[k];
    }
  delete [] ColName;

  // j'initialise le NTuple a zero, pour le dimensionner
  // (SetXVal suppose que le ntuple est deja dimensionne)
  r_8* dligne;
  r_4* fligne;
  int_4* iligne;
  char** cligne;
  if (DfitsCol.size()>0) 
    {
      if (dcolumn_ != NULL) delete [] dcolumn_;
      dcolumn_ = new double[nbentries];
      dligne = new r_8[DfitsCol.size()];
      for (int k=0; k<DfitsCol.size(); k++) dligne[k]=0.;
    }
  else dligne=NULL;
  if (FfitsCol.size()>0) 
    {
      if (fcolumn_ != NULL) delete [] fcolumn_;
      fcolumn_ = new float[nbentries];
      fligne = new r_4[FfitsCol.size()];
      for (int k=0; k<FfitsCol.size(); k++) fligne[k]=0.;
    }
  else fligne=NULL;
  if (IfitsCol.size()>0) 
    {
      if (icolumn_ != NULL) delete [] icolumn_;
      icolumn_ = new int[nbentries];
      iligne = new int_4[IfitsCol.size()];
      for (int k=0; k<IfitsCol.size(); k++) iligne[k]=0;
    } 
  else iligne=NULL;
  if (SfitsCol.size()>0) 
    {
      if (ccolumn_ != NULL)
	{
	  for (int k=0; k<dobj_->NEntry(); k++) delete [] ccolumn_[k];
	  delete [] ccolumn_;
	  ccolumn_ = NULL;
	}
      ccolumn_ = new char*[nbentries];
      int  taille_des_chaines=0;
      for (int k=0; k< SfitsCol.size(); k++)  taille_des_chaines = max( taille_des_chaines, fn.ColStringLengthFromFits(SfitsCol[k]) );
      for (int k=0; k<nbentries;k++) ccolumn_[k]= new char[taille_des_chaines+1];
      cligne = new char*[SfitsCol.size()];
      for (int k=0; k<SfitsCol.size(); k++) cligne[k]=" ";
    }
  else cligne=NULL;

  for (int k=0; k<nbentries;k++) dobj_->Fill(dligne, fligne, iligne, cligne);
  delete [] dligne;
  delete [] fligne;
  delete [] iligne;
  for (int k=0; k< SfitsCol.size(); k++) delete []  cligne[k];
  delete [] cligne; 
   
  compt=0;
  for (int k=0; k<DfitsCol.size(); k++)
    {
      fn.GetBinTabFCol(dcolumn_, nbentries, DfitsCol[k]);
      for (int nent=0; nent<nbentries; nent++) dobj_->SetDVal(nent,compt, dcolumn_[nent]);
      compt++;
    }
  
  for (int k=0; k<FfitsCol.size(); k++)
    {
      fn.GetBinTabFCol(fcolumn_,nbentries, FfitsCol[k]);
      for (int nent=0; nent<nbentries; nent++) dobj_->SetFVal(nent,compt, fcolumn_[nent]);
      compt++;
    }
              
  for (int k=0; k<IfitsCol.size(); k++)
    {
      fn.GetBinTabFCol(icolumn_,nbentries, IfitsCol[k]);
      for (int nent=0; nent<nbentries; nent++) dobj_->SetIVal(nent,compt, icolumn_[nent]);
      compt++;
    }
  
  for (int k=0; k<SfitsCol.size(); k++)
    {
      fn.GetBinTabFCol(ccolumn_,nbentries, SfitsCol[k]);
            for (int nent=0; nent<nbentries; nent++) dobj_->SetSVal(nent,compt, ccolumn_[nent]);
      compt++;
    }
  dobj_->Info()=fn.DVListFromFits();

}
void FITS_XNTuple::WriteToFits(const FitsFile& fn)
{
  if(dobj_ == NULL) 
    {
      cout << " WriteToFits:: dobj_= null " << endl;
      return;
    }

  // table will have 'ncols'  columns
  int ncols = dobj_->NVar(); 
  // table will have 'nrows' rows
  int nrows = dobj_->NEntry();
  // get names and values from the join DVList object
  DVList dvl= dobj_->Info();
  // extension name
  char* extname = "XNTuple_Binary_tbl"; 
  dvl.Print();
  char** Noms = new char*[ncols];   
  for (int k=0; k< ncols; k++)
    {
      Noms[k]= new char[LONNOM+1];
      strncpy(Noms[k],dobj_->NomIndex(k).c_str(),LONNOM+1);
    }
   char* types=new char[ncols+1];
  int compt=0;
  for (int k=0; k<dobj_->NDVar();k++)
    {
      types[compt++]='D'; 
    }
  for (int k=0; k<dobj_->NFVar();k++)
    {
      types[compt++]='E'; 
    }
  for (int k=0; k<dobj_->NIVar();k++)
    {
      types[compt++]='I'; 
    }
  for (int k=0; k<dobj_->NSVar();k++)
    {
      types[compt++]='A'; 
    }            
  types[ncols]='\0';
  vector<int> StringSizes(dobj_->NSVar());
  for (int k=0; k< StringSizes.size(); k++) StringSizes[k]=dobj_->mStrSz;
  // la librairie fitsio ecrit colonne par colonne 
    fn.makeHeaderBntblOnFits(types, Noms, nrows, ncols, dvl, extname,StringSizes); 
   for (int k=0; k< ncols; k++)
    {
      delete [] Noms[k];
    }
   delete [] Noms;
   delete [] types;
  compt=0;  
  for (int k=0; k<dobj_->NDVar();k++)
    {
      putColToFits(compt, dobj_->NEntry(), getColDFromObj(compt));
      compt++;
    }
  for (int k=0; k<dobj_->NFVar();k++)
    {
      putColToFits(compt, dobj_->NEntry(), getColFFromObj(compt));
      compt++;
    }
  for (int k=0; k<dobj_->NIVar();k++)
    {
      putColToFits(compt, dobj_->NEntry(), getColIFromObj(compt));
      compt++;
    }
  for (int k=0; k<dobj_->NSVar();k++)
    {
      putColToFits(compt, dobj_->NEntry(), getColSFromObj(compt));
      compt++;
    }
}
double* FITS_XNTuple::getColDFromObj(int colNr)
{
  if (dcolumn_ != NULL)
    {
      delete [] dcolumn_;
      dcolumn_ = NULL;
    }
  dcolumn_ = new double[dobj_->NEntry()];
  for(int j = 0; j < dobj_->NEntry(); j++) dcolumn_[j]= dobj_->GetDVal(j,colNr);
  return dcolumn_;
}

float* FITS_XNTuple::getColFFromObj(int colNr)
{
  if (fcolumn_ != NULL)
    {
      delete [] fcolumn_;
      fcolumn_ = NULL;
    }
  fcolumn_ = new float[dobj_->NEntry()];
  for(int j = 0; j < dobj_->NEntry(); j++) fcolumn_[j]= dobj_->GetFVal(j,colNr);
  return fcolumn_;
}
 
int* FITS_XNTuple::getColIFromObj(int colNr)
{
  if (icolumn_ != NULL)
    {
      delete [] icolumn_;
      icolumn_ = NULL;
    }
  icolumn_ = new int[dobj_->NEntry()];
  for(int j = 0; j < dobj_->NEntry(); j++) icolumn_[j]= dobj_->GetIVal(j,colNr);
  return icolumn_;
}
char** FITS_XNTuple::getColSFromObj(int colNr)
{
  if (ccolumn_ != NULL)
    { 
      for (int k=0; k<dobj_->NEntry(); k++) delete [] ccolumn_[k];
      delete [] ccolumn_;
      ccolumn_ = NULL;
    }
  ccolumn_ = new char*[dobj_->NEntry()];
  for(int j = 0; j < dobj_->NEntry(); j++)
    {
      string s= dobj_->GetSVal(j,colNr);
      ccolumn_[j] = new char[dobj_->mStrSz+1];
      strcpy(ccolumn_[j],s.c_str());
    }
  return ccolumn_; 
}
