// This may look like C code, but it is really -*- C++ -*-
//--------------------------------------------------------------------------
// File and Version Information:
//      $Id: derivblackbody.h,v 1.1 2000-04-11 13:26:05 ansari Exp $
//
// Description:
//
// History (add to end):
//      Sophie   Oct, 1999  - creation
//
//------------------------------------------------------------------------

#ifndef DERIVBLACKBODY_H_SEEN
#define DERIVBLACKBODY_H_SEEN

#include "radspec.h"
#include "convtools.h"

class DerivBlackBody : public RadSpectra
{
public:   //Constructor
  //Constructor
  DerivBlackBody (double temp = ConvTools::tcmb);

  virtual ~DerivBlackBody();

  virtual double flux(double nu) const;

  // returns the value of the temperature
  inline double getTemperature() const {return _temperature;} 

  // reset the value of the temperature with a new value
  inline void setTemperature(double newtemp) { _temperature = newtemp; }

  // Redefintion of the Print function
  virtual void      Print(ostream& os)  const;

protected:
  double _temperature;

};

#endif
