
#include "piapplmac.h"
#include "pippmenubar.h"
#include "pippapplmac.h"
#include "piwindowmac.h"

#include <LApplication.h>
#include <LGrowZone.h>
#include <UDrawingState.h>
#include <UMemoryMgr.h>
#include <SIOUX.h>
#include <LAttachment.h>

class PIInit {
public:
  PIInit() {
    SIOUXSettings.initializeTB = false;
    SIOUXSettings.standalone = false;
    SIOUXSettings.setupmenus = false;
    SIOUXSettings.showstatusline = true;
  }
};

PIInit piInit;

class PISIOUXAttachment : public LAttachment {
public:
  PISIOUXAttachment();
protected:
 virtual void	ExecuteSelf(
							MessageT		inMessage,
							void			*ioParam);
};

PISIOUXAttachment::PISIOUXAttachment()
: LAttachment()
{}

void PISIOUXAttachment::ExecuteSelf(MessageT msg, void* p)
{
  if (msg == msg_Event)
    mExecuteHost = !SIOUXHandleOneEvent((EventRecord*)p);
  if (!mExecuteHost)
    UDesktop::NormalizeWindowOrder();
}

PIApplicationMac::PIApplicationMac(int sx, int sy, int /*narg*/, char** /*arg*/)
{
  SIOUXSettings.initializeTB = false;
  SIOUXSettings.standalone = false;
  SIOUXSettings.setupmenus = false;
  SIOUXSettings.showstatusline = true;
									// Set Debugging options
	SetDebugThrow_(debugAction_Alert);
	SetDebugSignal_(debugAction_Alert);

	InitializeHeap(3);				// Initialize Memory Manager
									// Parameter is number of Master Pointer
									//   blocks to allocate
	
									// Initialize standard Toolbox managers
	UQDGlobals::InitializeToolbox(&qd);
	
	new LGrowZone(20000);			// Install a GrowZone function to catch
									//    low memory situations.
									
		// Register functions to create core PowerPlant classes
	
	RegisterAllPPClasses();

	macAppli = new PIPPApplMac;
	macAppli->AddAttachment(new PISIOUXAttachment);
	
    menubar = new PIMenubar(this, "DefMenubar");
    topcont = new PIWindowMac(this, "TopLevel", PIWK_floating, sx, sy, 10, 45);
}


PIApplicationMac::~PIApplicationMac()
{
	delete macAppli;
}

void
PIApplicationMac::Run()
{
    topcont->Show();
	macAppli->Run();
}

void
PIApplicationMac::Stop()
{
	macAppli->DoQuit();
}

/* --Methode-- */
int PIApplicationMac::PrefXSize()
{
  return(10);  // $CHECK$ A remplacer Reza 13/02/98 
}

/* --Methode-- */
int PIApplicationMac::PrefYSize()
{
  return(18);  // $CHECK$ A remplacer Reza 13/02/98 
}

void PIApplicationMac::RedirectOutStream(PIConsole* cons, unsigned char va)
{}
void PIApplicationMac::RedirectErrStream(PIConsole* cons, unsigned char va)
{}
