#include "generalfit.h"
#include "piscdrawwdg.h"

PIScDrawWdg::PIScDrawWdg(PIContainerGen *par, char *nom,
                         int sx, int sy, int px, int py)
:PIBaseWdg(par, nom, sx, sy, px, py)
{
  mBDrw = new PIDrawer;
  SetLimits(-1.,1.,-1.,1.);
  FreeLimits();
  xEndDrag = yEndDrag = xBegDrag = yBegDrag = 0;

  padsup = false;
  mTrlb = mTxw = NULL;
  mTrW = NULL;
  SetTextWin(NULL);
  ActivateButton(1);    // Pour pouvoir activer la fenetre et coordonnees
  ActivateMove(1);      //    "         "         "        "
  ActivateButton(2);
  ActivateMove(2);

}

PIScDrawWdg::~PIScDrawWdg()
{
  DeleteScDrawers();
  delete mBDrw;
  if (mTrW)  delete mTrW;
}


void
PIScDrawWdg::SetLimits(float xmin, float xmax, float ymin, float ymax,
                       int axrl, int ayud, bool tmp)
{
  if (xmax <= xmin || ymax <= ymin)
    return; // $CHECK$ exception ?
  mBDrw->SetLimits(xmin, xmax, ymin, ymax, axrl, ayud);
  mPPos[0] = 0.5*(XMin()+XMax());
  mPPos[1] = 0.5*(YMin()+YMax());
  if (!tmp) {
    xMinS = xmin;
    xMaxS = xmax;
    yMinS = ymin;
    yMaxS = ymax;
  }
}

void
PIScDrawWdg::Resize()
{
  //  SetSpan();
  //  Refresh();  $CHECK$ Faut-il appeler ? Reza 08/02/98
}

PIGraphicUC*
PIScDrawWdg::SetSpan(PIGraphicGen* g)
{
  int x0, y0, dx, dy;
  x0 = (int)(XSize()*0.12);
  y0 = (int)(YSize()*0.12);
  dx = (int)(XSize()*0.76+0.5);
  dy = (int)(YSize()*0.76+0.5);
  return(mBDrw->SetDrwWdg(this, x0, y0, dx, dy, g));
}

void
PIScDrawWdg::DrawAxes(PIGraphicUC* g, int flags)
{
  mBDrw->DrawAxes(g, flags);
}


void
PIScDrawWdg::SetAxesFlags(int flags)
{
  mBDrw->SetAxesFlags(flags);
}
  

void
PIScDrawWdg::AddScDrawer(PIScDrawer* d, bool ad)
{
  bool pd=false;
  if (mScDrawers.size() == 0)  pd = true;
  mScDrawers.push_back(d);
  d->AttachTo(this, ad, pd);
}

void
PIScDrawWdg::RemoveScDrawer(PIScDrawer* d)
{
  if (padsup)  return;
  vector<PIScDrawer*>::iterator drw;
  for(drw = mScDrawers.begin(); drw != mScDrawers.end(); drw++) 
    if (d == (*drw)) { mScDrawers.erase(drw);  break; }
  d->mDrawWdg = NULL;  d->mDrawer = NULL;
}

int 
PIScDrawWdg::NbScDrawers()
{
  return(mScDrawers.size());
}

PIScDrawer*
PIScDrawWdg::ScDrawer(int i)
{
 if ( (i<0) || (i>mScDrawers.size()) )  return(NULL);
 return(mScDrawers[i]);
}


void
PIScDrawWdg::DeleteScDrawers()
{
  padsup = true;
  vector<PIScDrawer*>::iterator i;
  for(i = mScDrawers.begin(); i != mScDrawers.end(); i++) {
    if ( (*i)->ADelByDrwWdg() )  delete *i;
  }
  mScDrawers.erase(mScDrawers.begin(),mScDrawers.end());
  padsup = false;
}

void
PIScDrawWdg::CallScDrawers(PIGraphicUC* g, float xmin, float ymin, float xmax, float ymax)
{
  vector<PIScDrawer*>::iterator drw;
  for(drw = mScDrawers.begin(); drw != mScDrawers.end(); drw++) {
    g->SaveGraphicAtt();
    (*drw)->SelGraAtt(g);
    (*drw)->Draw(g, xmin, ymin, xmax, ymax);
    g->RestoreGraphicAtt();
  }
}

void
PIScDrawWdg::SetTextWin(PILabel * tw, bool trw, int tx, int ty)
{
mTxw = tw;
if (trw)
  {
  if (mTrW)  mTrW->SetSize(tx, ty);
  else
    {
    mTrW = new PIWindow(this, "Point", PIWK_transient, tx, ty, 0, 0);
    mTrW->SetAutoDelChilds(true);
    mTrlb = new PILabel(mTrW, "PointCoord", tx, ty, 0, 0);
    mTrlb->SetBinding(PIBK_fixed,PIBK_fixed, PIBK_fixed,PIBK_fixed);
    }
  }
else
  if (mTrW) { delete mTrW; mTrW = NULL;  mTrlb = NULL; }

return;
}

void
PIScDrawWdg::Draw(PIGraphic* g)
{
  EraseWindow();
  PIGraphicUC* guc = SetSpan(g);
  DrawAxes(guc);
  DrawSelf(guc, -9.e19, -9.e19, 9.e19, 9.e19);
  CallScDrawers(guc, -9.e19, -9.e19, 9.e19, 9.e19);
}

void
PIScDrawWdg::Draw(PIGraphic* g, int x0, int y0, int dx, int dy)
{
  float xmin,xmax,ymin,ymax;
  PIGraphicUC* guc = SetSpan(g);
  guc->GrC2UC(x0, y0, xmin, ymin);
  guc->GrC2UC(x0+dx, y0+dy, xmax, ymax);
  if (xmin > xmax) swap(xmin,xmax);
  if (ymin > ymax) swap(ymin,ymax);
  DrawAxes(guc);
  DrawSelf(guc, xmin, ymin, xmax, ymax);
  CallScDrawers(guc, xmin, ymin, xmax, ymax);  
}


void
PIScDrawWdg::DrawSelf(PIGraphicUC*, float /*xmin*/, float /*ymin*/, float /*xmax*/, float /*ymax*/)
{
return;
}


// Gestion affichage coordonnees du point 


string   PIScDrawWdg::GetClickText(float x, float y) 
// Donne le texte a afficher pour position x,y  
{
  char buff[128];
  sprintf(buff, "X= %g  Y= %g",  x, y);
  return((string)buff);
}

void
PIScDrawWdg::But1Press(int x, int y)
{
  if (UpdateText(x, y))
     {
     if (mTrW)
       { 
       int tpx, tpy;
       GetScreenPos(tpx, tpy);       
       tpy -= (mTrW->YSize()+5);
       if (tpy < 0)  tpy = 0;
       mTrW->SetPos(tpx, tpy);
       mTrW->Show();
       }
     SelPointerShape(PI_CrossPointer);
     }
  Send(Msg(), PIMsg_Active);

}

void
PIScDrawWdg::Ptr1Move(int x, int y)
{
  UpdateText(x, y);
}

void
PIScDrawWdg::But1Release(int x, int y)
{
  if (UpdateText(x, y)) 
    SelPointerShape(PI_ArrowPointer);
  if (mTrW)  mTrW->Hide();
}

bool
PIScDrawWdg::UpdateText(int xp, int yp)
{

  float dx, dy;
  mBDrw->GetGraphicUC()->GrC2UC(xp, yp, dx, dy); 
  mPPos[0] = dx;  mPPos[1] = dy; 
  if ((mTxw == NULL) && (mTrlb == NULL)) return(false);
  
  string ctxt =  GetClickText(dx, dy);

  if (mTxw)
    mTxw->SetLabel(ctxt);
  if (mTrlb)
    mTrlb->SetLabel(ctxt);
  return(true);

}

// Gestion du zoom
void
PIScDrawWdg::But2Press(int x, int y)
{
  xEndDrag = xBegDrag = x;
  yEndDrag = yBegDrag = y;
  cForCol = mWGrC->GetForeground();
  cGOmod  = mWGrC->GetGOMode();
  cPointer = GetPointerShape();
  cLatt = mWGrC->GetLineAtt();
  SelPointerShape(PI_CrossPointer);
  mWGrC->SelForeground(PI_Magenta);
  mWGrC->SelGOMode(PI_GOXOR);
  mWGrC->SelLine(PI_ThinLine);
  Send(Msg(), PIMsg_Active);
}

void
PIScDrawWdg::But2Release(int /*x*/, int /*y*/)
{

  mWGrC->DrawBox(xBegDrag, yBegDrag, xEndDrag-xBegDrag, yEndDrag-yBegDrag);

  mWGrC->SelForeground(cForCol);
  mWGrC->SelGOMode(cGOmod);
  SelPointerShape(cPointer); 
  mWGrC->SelLine(cLatt); 
  
  if (xBegDrag == xEndDrag || yBegDrag == yEndDrag)
    SetLimits(xMinS, xMaxS, yMinS, yMaxS, kAxeDirSame, kAxeDirSame );
  else {
    float xl,yl,xh,yh;
    mBDrw->GetGraphicUC()->GrC2UC(xBegDrag, yBegDrag, xl, yl);
    mBDrw->GetGraphicUC()->GrC2UC(xEndDrag, yEndDrag, xh, yh);
    if (xl > xh) swap(xl, xh);
    if (yl > yh) swap(yl, yh);
    SetLimits(xl,xh,yl,yh, kAxeDirSame, kAxeDirSame, true);
  }
  
  Refresh();
}

void
PIScDrawWdg::Ptr2Move(int x, int y)
{
  mWGrC->DrawBox(xBegDrag, yBegDrag, xEndDrag-xBegDrag, yEndDrag-yBegDrag);
  xEndDrag = x;
  yEndDrag = y;
  mWGrC->DrawBox(xBegDrag, yBegDrag, xEndDrag-xBegDrag, yEndDrag-yBegDrag);
}

//================================================================
// PIScDrawer
//================================================================



PIScDrawer::PIScDrawer()
: mDrawWdg(NULL), mDrawer(NULL)
{
  mADbW = mAdDO = mPrDw = false;
  mFCol = mBCol = PI_NotDefColor;
  mLAtt = PI_NotDefLineAtt;
  mFSz = PI_NotDefFontSize;
  mFAtt = PI_NotDefFontAtt;
  mMSz = -1;
  mMrk = PI_NotDefMarker;
}

PIScDrawer::~PIScDrawer()
{
  if (mDrawWdg)
    mDrawWdg->RemoveScDrawer(this);
}

void
PIScDrawer::UpdateSize()
{
// Ne fait rien !
  return;
}

void
PIScDrawer::Refresh()
{
// Recalcule les limites, et reaffiche
  if (!mDrawWdg) return;
  mDrawWdg->FreeLimits();
  UpdateSize();
  if (mDrawWdg) mDrawWdg->Refresh();
}

void
PIScDrawer::AttachTo(PIScDrawWdg* wdg, bool ad, bool prd)
{
  if (mDrawWdg)
    mDrawWdg->RemoveScDrawer(this);
  mDrawWdg = wdg;  mDrawer = wdg->BaseDrawer(); 
  UpdateSize();
  mADbW = ad;
  mPrDw = prd;
}

// Classe PIDrawer special pour enrober un PIScDrawer en PIDrawer
class PIScContDrw : public PIDrawer {
public :
                     PIScContDrw(PIScDrawer* d, bool ad=false);
  virtual            ~PIScContDrw();
  virtual  void      Draw(PIGraphicUC* g);
  virtual  void      Draw(PIGraphicUC* g, float xmin, float ymin, float xmax, float ymax);
private:
  PIScDrawer* mScDrw;
  bool mAD;
};

PIScContDrw::PIScContDrw(PIScDrawer* d, bool ad)  
{ 
  mScDrw = d; 
  mAD=ad; 
}

PIScContDrw::~PIScContDrw() 
{ 
  if (mAD)  delete mScDrw; 
}

void PIScContDrw::Draw(PIGraphicUC* g) 
{ 
  mScDrw->SelGraAtt(g); 
  mScDrw->Draw(g, -9.e19, -9.e19, 9.e19, 9.e19); 
}

void PIScContDrw::Draw(PIGraphicUC* g, float xmin, float ymin, float xmax, float ymax)
{ 
  mScDrw->SelGraAtt(g); 
  mScDrw->Draw(g, xmin, ymin, xmax, ymax); 
}

PIDrawer*
PIScDrawer::Convert()
{
  PIScContDrw* rd;
  if (mDrawWdg) mDrawWdg->RemoveScDrawer(this);
  rd = new PIScContDrw(this);
  mDrawWdg = NULL;    mDrawer = rd;
  UpdateSize();
  return((PIDrawer*)rd);
}

void 
PIScDrawer::SetColAtt(PIColors fg, PIColors bg)
{
  if (fg != PI_NotDefColor) mFCol = fg;
  if (bg != PI_NotDefColor) mBCol = bg;
}

void 
PIScDrawer::SetLineAtt(PILineAtt lat)
{
  if (lat != PI_NotDefLineAtt) mLAtt = lat;
}

void 
PIScDrawer::SetFontAtt(PIFontSize fsz, PIFontAtt fat)
{
  if (fsz != PI_NotDefFontSize) mFSz = fsz;
  if (fat != PI_NotDefFontAtt) mFAtt = fat;
}

void 
PIScDrawer::SetMarkerAtt(int sz, PIMarker mrk)
{
  if (sz >= 0)  mMSz = sz;
  if (mrk != PI_NotDefMarker) mMrk = mrk;
}

void 
PIScDrawer::SelGraAtt(PIGraphicUC* g)
{
  if (mFCol != PI_NotDefColor)    g->SelForeground(mFCol);
  if (mBCol != PI_NotDefColor)    g->SelBackground(mBCol);
  if (mLAtt != PI_NotDefLineAtt)  g->SelLine(mLAtt);
  if ( (mFSz != PI_NotDefFontSize) || (mFAtt != PI_NotDefFontAtt) )
                                  g->SelFont(mFSz, mFAtt);
  if ( (mMrk != PI_NotDefMarker) || (mMSz >= 0) )
                                  g->SelMarker(mMSz, mMrk);
}

//================================================================
// PIScFuncDrawer
//================================================================

PIScFuncDrawer::PIScFuncDrawer(PIScFuncDrawer::FUNC f)
: mFunc(f)
{}

PIScFuncDrawer::~PIScFuncDrawer()
{
}

void
PIScFuncDrawer::Draw(PIGraphicUC* g, float /*xmin*/, float/*ymin*/, float/*xmax*/, float/*ymax*/)
{
  PIGrCoord x1, x2, y1, y2;
  g->GetGrSpace(x1, x2, y1, y2);
  float xMax = x2;
  float xMin = x1;
  float yMax = y2;
  float yMin = y1;
  float xStep = (xMax - xMin)/100;
  float xOld = xMin;
  float yOld = mFunc(xMin);
  for (float x = xMin+xStep; x<xMax; x+=xStep) {
    double y = mFunc(x);
    if (y>yMin && yOld>yMin && 
        y<yMax && yOld<yMax) 
           g->DrawLine(xOld, yOld, x, y);
    xOld = x;
    yOld = y;
  }
}

//================================================================
// PIScGFFDrawer
//================================================================

PIScGFFDrawer::PIScGFFDrawer(GeneralFunction* f)
: mFunc(f), mNParms(f->NPar()), mParms(new double[mNParms])
{
  ASSERT(f->NVar() == 1);
}

PIScGFFDrawer::~PIScGFFDrawer()
{
  delete[] mParms;
}

void
PIScGFFDrawer::SetParms(double const* p)
{
  for (int i=0; i<mNParms; i++)
    mParms[i] = p[i];
}


void
PIScGFFDrawer::Draw(PIGraphicUC* g, float /*xmin*/, float/*ymin*/, float/*xmax*/, float/*ymax*/)
{
  PIGrCoord x1, x2, y1, y2;
  g->GetGrSpace(x1, x2, y1, y2);
  float xMax = x2;
  float xMin = x1;
  float yMax = y2;
  float yMin = y1;
  float xStep = (xMax - xMin)/100;
  float xOld = xMin;
  float yOld = 0;
//  float yOld = f->Value(&xMin, mParms);
  for (float x = xMin+xStep; x<xMax; x+=xStep) {
   float y = 0; // $CHECK$
//    float y = f->Value(&x, mParms);
    if (y>yMin && yOld>yMin && 
        y<yMax && yOld<yMax) 
           g->DrawLine(xOld, yOld, x, y);
    xOld = x;
    yOld = y;
  }
}

