// This may look like C code, but it is really -*- C++ -*-
// g++ (up to 2.95.1) doesn't handle these inline template
// functions correctly - with math functions defined in math.h
//                     R. Ansari, C.Magneville   04/2000

// --- This file should not be included directly -----
//   conditional include only in matharr.h

#ifndef GCCARRMATHPB_SEEN
#define GCCARRMATHPB_SEEN

inline double _Sqrt_(double x) { return(sqrt(x)) ; } 
inline double _Fabs_(double x) { return(fabs(x)) ; } 
inline double _Sin_(double x) { return(sin(x)) ; } 
inline double _Cos_(double x) { return(cos(x)) ; } 
inline double _Tan_(double x) { return(tan(x)) ; } 
inline double _aSin_(double x) { return(asin(x)) ; } 
inline double _aCos_(double x) { return(acos(x)) ; } 
inline double _aTan_(double x) { return(atan(x)) ; } 
inline double _Exp_(double x) { return(exp(x)) ; } 
inline double _Log_(double x) { return(log(x)) ; } 
inline double _Log10_(double x) { return(log10(x)) ; } 

// ----- Instantiation pour r_8
inline TArray<r_8> fabs(const TArray<r_8>& a)
  { MathArray<r_8> ma;   return( ma.ApplyFunction(a, _Fabs_) ); }

inline TArray<r_8> sqrt(const TArray<r_8>& a)
  { MathArray<r_8> ma;   return( ma.ApplyFunction(a, _Sqrt_) ); }

inline TArray<r_8> sin(const TArray<r_8>& a)
  { MathArray<r_8> ma;   return( ma.ApplyFunction(a, _Sin_) ); }

inline TArray<r_8> cos(const TArray<r_8>& a)
  { MathArray<r_8> ma;   return( ma.ApplyFunction(a, _Cos_) ); }

inline TArray<r_8> tan(const TArray<r_8>& a)
  { MathArray<r_8> ma;   return( ma.ApplyFunction(a, _Tan_) ); }

inline TArray<r_8> asin(const TArray<r_8>& a)
  { MathArray<r_8> ma;   return( ma.ApplyFunction(a, _aSin_) ); }

inline TArray<r_8> acos(const TArray<r_8>& a)
  { MathArray<r_8> ma;   return( ma.ApplyFunction(a, _aCos_) ); }

inline TArray<r_8> atan(const TArray<r_8>& a)
  { MathArray<r_8> ma;   return( ma.ApplyFunction(a, _aTan_) ); }

inline TArray<r_8> exp(const TArray<r_8>& a)
  { MathArray<r_8> ma;   return( ma.ApplyFunction(a, _Exp_) ); }

inline TArray<r_8> log(const TArray<r_8>& a)
  { MathArray<r_8> ma;   return( ma.ApplyFunction(a, _Log_) ); }

inline TArray<r_8> log10(const TArray<r_8>& a)
  { MathArray<r_8> ma;   return( ma.ApplyFunction(a, _Log10_) ); }


// ----- Instantiation pour r_4
inline TArray<r_4> fabs(const TArray<r_4>& a)
  { MathArray<r_4> ma;   return( ma.ApplyFunction(a, _Fabs_) ); }

inline TArray<r_4> sqrt(const TArray<r_4>& a)
  { MathArray<r_4> ma;   return( ma.ApplyFunction(a, _Sqrt_) ); }

inline TArray<r_4> sin(const TArray<r_4>& a)
  { MathArray<r_4> ma;   return( ma.ApplyFunction(a, _Sin_) ); }

inline TArray<r_4> cos(const TArray<r_4>& a)
  { MathArray<r_4> ma;   return( ma.ApplyFunction(a, _Cos_) ); }

inline TArray<r_4> tan(const TArray<r_4>& a)
  { MathArray<r_4> ma;   return( ma.ApplyFunction(a, _Tan_) ); }

inline TArray<r_4> asin(const TArray<r_4>& a)
  { MathArray<r_4> ma;   return( ma.ApplyFunction(a, _aSin_) ); }

inline TArray<r_4> acos(const TArray<r_4>& a)
  { MathArray<r_4> ma;   return( ma.ApplyFunction(a, _aCos_) ); }

inline TArray<r_4> atan(const TArray<r_4>& a)
  { MathArray<r_4> ma;   return( ma.ApplyFunction(a, _aTan_) ); }

inline TArray<r_4> exp(const TArray<r_4>& a)
  { MathArray<r_4> ma;   return( ma.ApplyFunction(a, _Exp_) ); }

inline TArray<r_4> log(const TArray<r_4>& a)
  { MathArray<r_4> ma;   return( ma.ApplyFunction(a, _Log_) ); }

inline TArray<r_4> log10(const TArray<r_4>& a)
  { MathArray<r_4> ma;   return( ma.ApplyFunction(a, _Log10_) ); }

#endif
