#ifndef FITSIOSERVER_SEEN
#define FITSIOSERVER_SEEN

#include "machdefs.h" 
#include "tarray.h"
#include "tmatrix.h"
#include "tvector.h"
#include "skymap.h"
#include "ntuple.h"
#include "cimage.h"
#include "FitsIO/fitsio.h"    

#define LEN_KEYWORD 9

class FitsIoServer 
{

public :

  FitsIoServer() : FITS_tab_typ_(0),i_4tab_(NULL),r_4tab_(NULL),r_8tab_(NULL) 
  {;}
 virtual ~FitsIoServer()
   {
     if (i_4tab_ != NULL) delete [] i_4tab_;
     if (r_4tab_ != NULL) delete [] r_4tab_;
     if (r_8tab_ != NULL) delete [] r_8tab_;
   }

 void load(TMatrix<double>& mat, char flnm[]);
 void load(TMatrix<float>& mat, char flnm[]);
 void load(TMatrix<int_4>& mat, char flnm[]);
 void load(NTuple& ntpl,char flnm[],int hdunum);
 void load(SphericalMap<double>& sph, char flnm[]);
 void load(SphericalMap<float>& sph, char flnm[]);
 void load(LocalMap<double>& sph, char flnm[]);
 void load(ImageR4& DpcImg,char flnm[]);
 void load(ImageI4& DpcImg,char flnm[]);
 void load(SphereHEALPix<float>& sph, char flnm[], int nth=1); 
 void load(SphereHEALPix<double>& sph, char flnm[], int nth=1); 
 void load(SphereHEALPix<double>& sph1,SphereHEALPix<double>& sph2,SphereHEALPix<double>& sph3, char filename[]); 
 void load(SphereHEALPix<float>& sph1,SphereHEALPix<float>& sph2,SphereHEALPix<float>& sph3, char filename[]); 
 void save(TMatrix<double>& mat, char flnm[]);
 void save(TMatrix<float>& mat, char flnm[]);
 void save(TMatrix<int_4>& mat, char flnm[]);
 void save(NTuple& ntpl,char flnm[]);
 void save(SphericalMap<double>& sph, char flnm[]);
 void save(SphericalMap<float>& sph, char flnm[]);

 // nth : numero d'ordre de la sphere sur le fichier de sauvegarde
 // si on veut sauver une seule sphere : nth=1
 // so veut sauver par exemple 3 spheres, on appelle 3 fois save
 // avec respectivement nth=1, 2, 3  
 void save(SphereHEALPix<float>& sph, char filename[], int nth=1); 
 void save(SphereHEALPix<double>& sph, char filename[], int nth=1); 
  
 void save(SphereHEALPix<double>& sph1,SphereHEALPix<double>& sph2,SphereHEALPix<double>& sph3, char filename[]);   
 void save(SphereHEALPix<float>& sph1,SphereHEALPix<float>& sph2,SphereHEALPix<float>& sph3, char filename[]);   
 void save(const LocalMap<double>& locm, char flnm[]);
 void save(const ImageR4& DpcImg,char flnm[]);
 void save(const ImageI4& DpcImg,char flnm[]);
 void sinus_picture_projection(SphericalMap<double>& sph, char flnm[]);
 void sinus_picture_projection(SphericalMap<float>& sph, char flnm[]);
 void Mollweide_picture_projection(SphericalMap<float>& sph, char flnm[]);
 void Mollweide_picture_projection(SphericalMap<double>& sph, char flnm[]);
 void picture(LocalMap<double>& lcm, char flnm[]);
 void readheader(char flnm[]);
 
 virtual AnyDataObj* loadobj(char flnm[],int hdunum = 1);

 private :

 // creer, ecrire une imageformat FITS, a partir des tableaux de donnees 
 // dtab_, ftab_ prealablement remplis 
 void planck_write_img(char flnm[],int naxis,int n1,int n2,int n3,DVList &dvl);

 void planck_read_img(char flnm[],int &naxis,int &n1,int &n2,int &n3,DVList &dvl);
 void planck_read_bntbl(char flnm[], int hdunum, int& npixels, DVList& dvl,int tfields=1);
 void planck_write_bntbl(char flnm[], int npixels, char typeOfContent[], char extname[], char comment1[], DVList& dvl, int tfields=1, int nth=1);
 void write_picture(long* naxes,float* map,char* filename) const;

 void printerror(int& status) const;
 void printerror(int& status, char* texte) const;
 bool check_keyword(fitsfile*,int,char keyword[]);

 inline int key_type_PL2FITS(char typ) 
   {
     switch (typ) 
       {
       case 'I' :
	 return TINT;
       case 'D' : 
	 return TDOUBLE;
       case 'S' : 
	 return TSTRING;
       default :
	 cout << " FITSIOSERVER : type de donnee non prevu " << endl;
	 return 0;
       }
   }

 int FITS_tab_typ_;
 int_4* i_4tab_;
 r_4* r_4tab_;
 r_8* r_8tab_;
};

#endif

 

