// This may look like C code, but it is really -*- C++ -*-
//
// $Id: datacards.h,v 1.2 2000-04-12 17:49:43 ansari Exp $
//
// Datacards, acquisition EROS II
//
//
// Eric Aubourg, Decembre 95
// Reza Ansari, Aout 96
//
// DAPNIA/SPP (Saclay) / CEA    LAL - IN2P3/CNRS  (Orsay)

#ifndef DATACARDS_SEEN
#define DATACARDS_SEEN

#include "machdefs.h"
#include <string.h>
#include <string>
#include <functional>
#include <list>
#include <vector>


namespace SOPHYA {  

typedef int (*ProcCard)(string const& key, string const& toks);
 
//! Class for decoding parameters from  an ascii file.
    
class DataCards  {
public:

   DataCards();                  
   DataCards(string const& fn);

           // nom dans variable d'environnement SOPHYA_DATACARDS
           // par defaut, sophya.datacards                        
           // Si pas chemin complet, on tente dans repertoire 
           // en cours, puis dans SOPHYA_WORK

   virtual ~DataCards() {}

   void    AddProcF(ProcCard f, string const& mtch="*");

   void    Clear();
   void    ReadFile(string const& fn);
   void    AppendCard(string const& line);

   int     NbCards();
   bool    HasKey(string const& key);
   int     NbParam(string const& key);
   string  SParam(string const& key, int numero = 0, string def="");
   long    IParam(string const& key, int numero = 0, long def = 0);
   double  DParam(string const& key, int numero = 0, double def = 0);
   
   void    Print(ostream& s) const;

protected:
   struct Card {
     string kw;
     vector<string> tokens;
     bool operator == (Card const & b) const { return(kw == b.kw); }
     bool operator < (Card const & b) const { return(kw < b.kw); }
   };
   struct CrdPF {
     ProcCard pf;
     string  patt;
     bool operator == (CrdPF const & b) const { return(pf == b.pf); }
     bool operator < (CrdPF const & b) const { return(pf == b.pf); }
   };

   void  DoReadFile(string const& fn);

   int   ApplyPF(CrdPF & cpf, string const& key, string const& toks);
   int   ApplyPFL(string const& key, string const& toks);

   void  RemoveCard(string const& key);
   
   Card* FindKey(string const& key);

   typedef list<Card> CardList;
   typedef list<CrdPF> CrdPFList;
   CardList cards;
   CrdPFList cpfs;

   struct KeyEq : binary_function<Card, string, bool> {
    bool operator()(const Card& x, const string& y) const { return x.kw == y; }
   };
};

//! operator << overloading - calls Print()
inline ostream& operator << (ostream& s, DataCards c)
{ c.Print(s); return s; }

} // namespace SOPHYA

#endif
