// This may look like C code, but it is really -*- C++ -*-
//
// $Id: ctimer.h,v 1.3 2000-04-12 17:49:41 ansari Exp $
//


#ifndef CTIMER_SEEN
#define CTIMER_SEEN

#include "machdefs.h"
#include <sys/types.h>
#include <time.h>
#include <iostream.h>
#include <stdio.h>
#include <string>

// <summary> Permet de chronometrer des fonctions. </summary>
// La macro TIMEF cree un objet de class Timer qui memorise
// l'heure de sa creation, et le temps CPU.

// A la fin du bloc ou de la procedure, l'objet est detruit,
// et son destructeur affiche le temps ecoule.

// La macro SPLITTIME lui permet d'afficher des temps partiels.
namespace SOPHYA {

//! Simple chronometer class
class Timer  {
public:
  // L'objet memorise le temps CPU et l'heure, et le nom donne
  Timer(const char* name=0);

  // Le destructeur appelle split sans parametre.
  virtual ~Timer();

  // Affiche le temps ecoule total/partiel, avec le nom eventuel.
  // Si pas de parametre affiche le nom donne a la creation.
  void Split(const char* comm=0);

  // Sert a eviter que GNU ne pretende qu'on utilise pas l'objet...
  /*! To avoid not used object compiler warnings */
  void Nop() {}

private:
  clock_t cpu0, cpuSplit;
  time_t  elapse0, elapseSplit;
  string timerName;
};

} // namespace SOPHYA

#define TIMEN(x)  Timer timer(x); timer.Nop();
#define TIMEF     Timer timer(__PRETTY_FUNCTION__); timer.Nop();
#define SPLITTIME timer.Split();

#endif // CTIMER_SEEN
