// This may look like C code, but it is really -*- C++ -*-
// Classe d'objets avec une methode (DoPeriodic()) appelee periodiquement 
#ifndef PERIODIC_H
#define PERIODIC_H

#include "machdefs.h"
#include <list>

namespace SOPHYA {

class Periodic;
typedef list<Periodic*> PeriodicList;

typedef void (* UsPeriodicAction) (void *);

//! Class for the execution of a periodic action
class Periodic 
{
public:
  Periodic(int dt, UsPeriodicAction act=NULL, void * usp=NULL);
  virtual ~Periodic();

  void SetAction(UsPeriodicAction act, void * usp=NULL);

  virtual void SetInterval(int dt);
  virtual void SetIntervalms(int dtms);

/*! Returns the time interval in seconds >= 1 sec */
  inline int Interval() { return(mDt); }
/*! Returns the time interval in milli-second */
  inline int Intervalms() { return(mDtms); }

  virtual void Start(int dt=-1);
  virtual void Stop();

  virtual void DoPeriodic();

  static PeriodicList* actifs;
  static void CallBack(int);

protected:
  int mDt, mDtms, it;
  UsPeriodicAction mAct;
  void * mUsp;
  bool mFgact;
};

} // namespace SOPHYA

#endif
