/*  Caracteristique du CCD      Reza  03/95  -*- C++ -*- */

#ifndef DYNCCD_H_SEEN
#define DYNCCD_H_SEEN

#include "machdefs.h"
#include "pexceptions.h"
#include "ppersist.h"

namespace SOPHYA {

enum {kConstantNoise = 0, kPhotonNoise, kSigFondNoise, kSqrtADUNoise};

class DynCCD 
{
  public :

  int_4 TypNoise;        // Type de calcul du bruit 
  float MinADU,MaxADU;   // Valeur min et max des pixels 
  float Gain;            // Gain en electron/ADU 
  float RONoise;         // Bruit de lecture en electron  
  float RefFond;         // Fond de ciel de ref (TypNoise=2) 
  float RefSFond;        // Sigma du fond  (TypNoise=2) */

/*    ===>  Les methodes   */
  DynCCD(int typ=0, float min=-9.e19, float max=9.e19,
         float g=1., float ron=0., float rf=0., float rfs=0.);

  void Set(int typ=0, float min=-9.e19, float max=9.e19,
         float g=1., float ron=0., float rf=0., float rfs=0.);
  void Print();
  float Noise(float pixel) const;
};

} // Fin du namespace

// Quelques fonctions pour manipuler des images de bruit

class RzImage;
RzImage * NoiseImage(RzImage const *pim, DynCCD const * dynccd);

template <class T> class Image;

template <class T>
Image<T> * NoiseImage(Image<T> const * pim, DynCCD const * dynccd);

template <class T>
void ImgAddNoise(Image<T>&, DynCCD const&);

// Les entrees-sortie

inline POutPersist& operator << (POutPersist& c, DynCCD const& data)
{
  c.PutI4(data.TypNoise);
  c.PutR4s(&data.MinADU, 6);
  return c;
}

inline 
PInPersist& operator >> (PInPersist& c, DynCCD& data)
{
  c.GetI4(data.TypNoise);
  c.GetR4s(&data.MinADU, 6);
  return c;
}

//STRUCTPERSISTIO(DynCCD, TypNoise, sizeof(int_4)+6*sizeof(float))


#endif
