// This may look like C code, but it is really -*- C++ -*-
// Classe interpreteur de commande pour piapp 
// Reza      Aout 97 , Juillet,Aout 98
// LAL-IN2P3/CNRS

#ifndef PIACMD_H_SEEN
#define PIACMD_H_SEEN

#include "machdefs.h"
#include <iostream.h>
#include <fstream.h>
#include <string>
#include <vector>
#include <map>
#include <functional>

#include "dlftypes.h"


// Classe definissant l'interface pour un executeur de commande
class CmdExecutor {
public:
  virtual	~CmdExecutor() {} ;
  // keyw : Le mot cle associe , args: Arguments de la commande
  virtual int	Execute(string& keyw, vector<string>& args)=0;
};

// Classe definissant l'interface pour un interpreteur de commande
class CmdInterpreter {
public:
  virtual		~CmdInterpreter() {} ;
  virtual string	Name()=0;
  virtual int		Interpret(string& line)=0;
};



// Forward declaration of some classes ...
class NamedObjMgr;
class PIStdImgApp;
#ifdef SANS_EVOLPLANCK
class Timer;
class PDynLinkMgr;
#else
namespace SOPHYA { 
class Timer;
class PDynLinkMgr;
}
#endif
class PIAHelpWind; // Fenetre d'aide en ligne 
class PIACmdBloc;

// ---------------------------------------------------------------------
// Classe Interpreteur de commande, gestionnaire de module chargeable,
// et de fonctions dynamiquement linke pour PIStdImgApp
// Permet de gerer plusieurs Interpreter differents 
// ---------------------------------------------------------------------


class PIACmd : public CmdInterpreter  {
public:
  static PIACmd*	GetInterpreter();

			PIACmd(NamedObjMgr* omg, PIStdImgApp* app);
  virtual		~PIACmd();
  virtual string	Name();

  virtual void		RegisterCommand(string& keyw, string& usage, CmdExecutor * ce, 
                                        string grp="Commands");
  virtual void		RegisterHelp(string& keyw, string& usage, string& grp);
  virtual void		LoadModule(string& fnameso, string& name);

  virtual void		AddInterpreter(CmdInterpreter * cl);
  virtual void		SelInterpreter(string& name);

  virtual int		Interpret(string& line);
  virtual int		ExecuteCommandLine(string& line);
  virtual int		ExecuteCommand(string& keyw, vector<string>& args);
  virtual int		ExecFile(string& file, vector<string>& args);

  virtual string&	GetUsage(const string& kw);
  virtual void		ShowHelpWindow();

  virtual void 		HelptoLaTex(string const & flnm);

  inline  CmdInterpreter* CurrentInterpreter() { return(curcmdi); }
  inline  CmdExecutor*    BaseExecutor()  { return(basexec); }
  inline  PIStdImgApp*    GetImgApp() { return(mImgApp); }

//   Pour utilisation par PIAHelpWind uniquement 
  virtual void		UpdateHelpList(PIAHelpWind* hw, int gid);

protected:
  virtual int		CheckHelpGrp(string& grp);

  NamedObjMgr* mObjMgr;
  PIStdImgApp* mImgApp;

  CmdInterpreter* curcmdi;
  CmdExecutor* basexec;
  CmdExecutor* fitexec;
  CmdExecutor* pawexec;

// Pour enregistrer la liste de commandes et leurs executeurs et le help
  struct cmdex {int group; string us; CmdExecutor * cex; } ;
  typedef map<string, int, less<string> > CmdHGroup;   // Liste des groupes de commandes
  CmdHGroup cmdhgrp;
  int cmdgrpid;                                     // Numero de groupe courant
  typedef map<string, cmdex, less<string> > CmdExmap;
  CmdExmap cmdexmap;
  CmdExmap helpexmap;                               // Pour les helps sans commande

// Pour garder la liste des modules 
  typedef map<string, PDynLinkMgr* , less<string> > Modmap;
  Modmap modmap;

// Pour garder la liste des interpreteur
  typedef map<string, CmdInterpreter*, less<string> > InterpMap;
  InterpMap interpmap;
 
//  Pour stocker les variables definies par l'interpreteur
  typedef map<string, string, less<string> > CmdVarList;
  CmdVarList mVars;     // Liste des variables 
  CmdVarList mAliases;  // Liste des alias 

  PIACmdBloc * curblk;  // Bloc de commande courant (foreach, ...)
  int felevel;          // foreah level 

  ofstream hist;       //  History file 
  bool histon;        //  True ->  history file
  bool trace;          // Trace flag
  bool timing;         // Display CPU Time
  Timer* gltimer;      // pour Display CPU Time

// Fenetre d'aide interactive 
  PIAHelpWind* helpwin;

};



#endif
