#include "piwdgmac.h"
#include "pisysdep.h"

#include PICONT_H

#include <LView.h>
#include <LString.h>

void PIBeep()
{
  ::SysBeep(1);
}


PIWdgMac::PIWdgMac(PIContainerGen *par, char *nom,
                   int sx, int sy, int px, int py)
:PIWdgGen(par, nom, sx, sy, px, py), mNom(nom)
{
	mPaneInfo.paneID    = 'PIWD';
	mPaneInfo.width     = sx;
	mPaneInfo.height    = sy;
	mPaneInfo.visible   = true;
	mPaneInfo.enabled   = true;
	mPaneInfo.bindings.left =
		mPaneInfo.bindings.top =
		mPaneInfo.bindings.right =
		mPaneInfo.bindings.bottom = false;
	mPaneInfo.left      = px;
	mPaneInfo.top       = py;
	mPaneInfo.userCon   = 'PIWD';
	mPaneInfo.superView = par ? (LView*) (((PIContainerMac*)(par))->mPane) : NULL;

    mPane = new LPane(mPaneInfo);
}


PIWdgMac::~PIWdgMac()
{
  delete mPane;
}

void
PIWdgMac::FinishCreate()
{
  mPane->FinishCreate();
}

void
PIWdgMac::ListenToMessage(MessageT /*inMessage*/, void */*ioParam*/)
{

}

void
PIWdgMac::SetLabel(string const& lab)
{
  LStr255 titre(lab.c_str());
  mPane->SetDescriptor(titre);
}

void
PIWdgMac::SetSize(int sx, int sy)
{
   mPane->ResizeFrameTo(sx, sy, true);
}

void
PIWdgMac::SetPos(int px, int py)
{
   mPane->MoveBy(px-XPos(), py-YPos(), false);
}

void
PIWdgMac::SetBinding(bool left, bool top, bool right, bool bottom)
{
  SBooleanRect r;
  r.left    = left;
  r.top     = top;
  r.right   = right;
  r.bottom  = bottom;
  mPane->SetFrameBinding(r);
}

int
PIWdgMac::XSize()
{ 
  SDimension16 outSize;
  mPane->GetFrameSize(outSize);
  return outSize.width;
}

int
PIWdgMac::YSize()
{ 
  SDimension16 outSize;
  mPane->GetFrameSize(outSize);
  return outSize.height;
}

int
PIWdgMac::XPos()
{
  SPoint32 p;
  mPane->GetFrameLocation(p);
  return p.h;
}

int
PIWdgMac::YPos()
{
  SPoint32 p;
  mPane->GetFrameLocation(p);
  return p.v;
}

