#include <stdio.h>
#include <X11/cursorfont.h>
#include "piapplx.h"
#include "picontainerx.h"


// Pour rediriger stdout 
#include <unistd.h>
#include <fcntl.h>


// #define DEBUG_APPLX

static Cursor a_curs[3];
static bool a_fgcur=false;

//  Voir fichier pimenux.cc , Pour resoudre certains conflits avec les WindowManagers
void SetTopWdgForMenuX(SysDWdg mtw);

/* --Methode-- */
PIApplicationX::PIApplicationX(int sx, int sy, int narg, char *arg[])
: PIApplicationGen()
{
int sxt, syt;

#ifdef DEBUG_APPLX
puts("PIApplicationX::PIApplicationX()_info : App creation");
#endif
mStop = true;
topwdg = new PIWdgX(narg, arg);

intcont = new PIContainerX((PIMsgHandler *)this, topwdg, "MBCont", 
                            10, 10, 0, 0);
// Pb avec les Popup MenuX et certains Window Manager , voir pimenux.cc
SetTopWdgForMenuX(intcont->XtWdg());

menubar = new PIMenubar(this, "DefMenubar");
Menubar()->SetBinding(PIBK_fixed, PIBK_fixed, PIBK_fixed, PIBK_free);
sxt = ( sx > Menubar()->XSize() ) ? sx : Menubar()->XSize();
syt = ( sy > 0 ) ? sy : 0;
//syt += Menubar()->YSize();
syt += 40;
MBCont()->SetSize(sxt, syt);
if ( (sx > 0) && (sy > 0) )
  {
  topcont = new PIContainerX(MBCont(), "TopLevelCont", 
                             sx, sy, 0, 40);
  topcont->SetBinding(PIBK_fixed, PIBK_fixed, PIBK_fixed, PIBK_fixed);
  topcont->Show();
  }
else topcont = MBCont();

MBCont()->Show();
topwdg->Manage();

if (!a_fgcur)
  {
  Display *mdsp;
  mdsp = XtDisplay (topwdg->XtWdg()); 
  a_curs[0] = XCreateFontCursor(mdsp, XC_arrow);
  a_curs[1] = XCreateFontCursor(mdsp, XC_X_cursor);
  a_curs[2] = XCreateFontCursor(mdsp, XC_watch);
  }

mState = -1;
SetReady();
}

/* --Methode-- */
PIApplicationX::~PIApplicationX()
{
#ifdef DEBUG_APPLX
puts("PIApplicationX::~PIApplicationX()_info : App delete");
#endif
Display *mdsp;
mdsp = XtDisplay (topwdg->XtWdg()); 
topwdg->UnManage();
delete menubar;
if (topcont != MBCont())  delete topcont;
delete intcont;
delete topwdg;
XtCloseDisplay(mdsp);
return;
}

/* --Methode-- */
void PIApplicationX::Run()
{
XEvent evt;
#ifdef DEBUG_APPLX
puts("PIApplicationX::Run()_info : App Run ");
#endif

topwdg->SetSize(MBCont()->XSize(), MBCont()->YSize());

int szx, szy;
XtAppContext * appctx = PIXtAppCtx(szx, szy);

while (mStop)
  {
  XtAppNextEvent(*appctx, &evt);
  XtDispatchEvent(&evt);
  }
return;
}


/* --Methode-- */
void PIApplicationX::SetReady()
{
if (mState != kReadyState)
  {
  Display * mdsp;
  mState = kReadyState;
  mdsp = XtDisplay (topwdg->XtWdg());
  XDefineCursor(mdsp, XtWindow(topwdg->XtWdg()), a_curs[0]);
  XFlush(mdsp);
  }
}

/* --Methode-- */
void PIApplicationX::SetBusy()
{
if (mState != kBusyState)
  {
  Display * mdsp;
  mState = kBusyState;
  mdsp = XtDisplay (topwdg->XtWdg());
//  if ( XtIsRealized(topwdg->XtWdg()) )
  XDefineCursor(mdsp, XtWindow(topwdg->XtWdg()), a_curs[2]);
  XFlush(mdsp);
  }
return;
}

/* --Methode-- */
void PIApplicationX::SetBlocked()
{
if (mState != kBlockedState)
  {
  Display * mdsp;
  mState = kBlockedState;
  mdsp = XtDisplay (topwdg->XtWdg());
  XDefineCursor(mdsp, XtWindow(topwdg->XtWdg()), a_curs[1]);
  XFlush(mdsp);
  }
}


/* --Methode-- */
void PIApplicationX::PrefCompSz(int& szx, int& szy)
{
PIXtAppCtx(szx, szy);
return;
}


/* Call-Back - Fonction privee de ce fichier */
static void redirectstream_callback(XtPointer, int *, XtInputId*);

static PIConsole* consstream[2] = {NULL, NULL};
static unsigned char streamva[2] = { PIVA_Def, PIVA_Ital};
static int streamno[2] = {0,1};

static void redirectstream_callback(XtPointer cld, int * fd, XtInputId* /*iid*/)
{
char buff[128];
int nr;

int idx = *((int*)cld);
if (idx != 1) idx = 0; 
while ( (nr=read(*fd, buff, 127)) > 0 ) {
  buff[nr] = '\0'; consstream[idx]->AddStr(buff, streamva[idx], false);
  }
consstream[idx]->Refresh();
}

/* --Methode-- */
void PIApplicationX::RedirectOutStream(PIConsole* cons, unsigned char va)
{
if (!cons) return;

if (consstream[0]) { consstream[0] = cons; streamva[0] = va; return; }
consstream[0] = cons; streamva[0] = va;

int p[2];
pipe(p);
// Redirection de stdout (fid=1) :  
close(1);
dup(p[1]);
close(p[1]);
fcntl(p[0], F_SETFL, O_NONBLOCK);
setlinebuf(stdout);

int szx, szy;
XtAppContext * appctx = PIXtAppCtx(szx, szy);
XtAppAddInput(*appctx, p[0], (XtPointer) XtInputReadMask, redirectstream_callback, (XtPointer) streamno);
}

/* --Methode-- */
void PIApplicationX::RedirectErrStream(PIConsole* cons, unsigned char va)
{
if (!cons) return;

if (consstream[1]) { consstream[1] = cons; streamva[1] = va; return; }
consstream[1] = cons; streamva[1] = va;

int p[2];
pipe(p);
// Redirection de stderr (fid=0) :
close(2);
dup(p[1]);
close(p[1]);
fcntl(p[0], F_SETFL, O_NONBLOCK);
setlinebuf(stderr);

int szx, szy;
XtAppContext * appctx = PIXtAppCtx(szx, szy);
XtAppAddInput(*appctx, p[0], (XtPointer) XtInputReadMask, redirectstream_callback, (XtPointer) (streamno+1));
}

