//  Classe de base d'objets application pour 
//  les programmes graphiques interactives
//
//                  E.Aubourg , R. Ansari  96 - 98
// LAL (Orsay) / IN2P3-CNRS  DAPNIA/SPP (Saclay) / CEA

//++
// Class	PIApplication
// Lib		PI
// include	piapplgen.h
//
//	Classe de base pour l'objet application. L'objet PIApplication 
//	doit tre cr avant la cration des autres objets de PI.
//	La classe "PIApplication" a implmentation dpendante 
//	du systeme utilis (Mac, XWindow, ...). La classe "PIApplicationGen" 
//	est la classe qui dfinit l'interface, et ne doit pas tre instancie 
//	directement (Mthodes virtuelles pures). Les objets instancis sont 
//	de la classes "PIApplication" et le fichier entte correspondant est 
//	"PIAPP_H" dfini dans "pisysdep.h".
//--
//++
// Links	Parents
// PIMsgHandler
//--
//++
// Titre	Constructeur
//--
//++
// PIApplication(int sx=200, int sy=30, int narg=0, char *arg[]=NULL)
//	Constructeur. "sx,sy" est la taille de la fentre principale
//	(ou PIContainer) associe  l'application. Des arguments
//	optionnels, par exemple celle de la ligne de commande peuvent 
//	tre transmis  l'objet PIApplication. Dans le cas d'Unix/XWindow
//	par exemple, les options reconnues par la Xtoolkit peuvent 
//	tre passes  l'objet application.
//--

//++
// Titre	Mthodes
//--
//++
// PIContainer*   MainWin()
//	Renvoie le pointeur de l'objet "PIContainer" associ  l'application.
// PIMenubar*   Menubar()
//	Renvoie le pointeur de l'objet "PIMenubar" associ  l'application.
// void AppendMenu(PIPDMenu *pdm)
//	Ajoute le "PIPDMenu *pdm" au Menubar de l'application. Le titre 
//	du menu dans le menubar est le nom de l'objet menu. 
// void Run() Stop
//	Dmarre, arrte la boucle d'vnements.
//--


#include "piapplgen.h"

// Variable qui contient le pointeur de l'application courante
// permet de recuperer la taille pref pour la fonction globale 
static PIApplicationGen * curapp = NULL;

PIApplicationGen::PIApplicationGen()
:topcont(NULL), menubar(NULL), mState(0)
{
curapp = this;   
}

PIApplicationGen::~PIApplicationGen()
{}


void PIApplicationGen::AppendMenu(PIPDMenu *pdm)
{
if (menubar)
  menubar->AppendMenu(pdm);
return;
}

void PIApplicationGen::SetReady()
{
mState = kReadyState;
}

void PIApplicationGen::SetBusy()
{
mState = kBusyState;
}

void PIApplicationGen::SetBlocked()
{
mState = kBlockedState;
}

int PIApplicationGen::GetState()
{
return mState;
}


void     PIApplicationPrefCompSize(int& szx, int& szy)
{
szx = szy = 10;
if (curapp)  curapp->PrefCompSz(szx, szy);
return; 
}
