// This may look like C code, but it is really -*- C++ -*-
//--------------------------------------------------------------------------
// File and Version Information:
//      $Id: nupower.h,v 1.6 2000-04-13 08:17:03 ansari Exp $
//
// Description:
//
// History (add to end):
//      Sophie   Oct, 1999  - creation
//
//------------------------------------------------------------------------

#ifndef NUPOWER_H_SEEN
#define NUPOWER_H_SEEN

#include "radspec.h"
#include "convtools.h"
namespace SOPHYA {
// Power law spectra  f = a ((nu-nu0)/dnu)^b   
class PowerLawSpectra : public RadSpectra
{
public:   //Constructor
  
  PowerLawSpectra();
  PowerLawSpectra(double a, double b, double nu0, double dnu, double numin=0., double numax=9.e49);

  virtual ~PowerLawSpectra();

  virtual double flux(double nu) const;

  // Redefintion of the Print function
  virtual void      Print(ostream& os)  const;
  
  virtual inline double giveNorm() const {return _a;};
  virtual inline double giveNu0() const {return _nu0;};
  virtual inline double giveDNu() const {return _dnu;};
  virtual inline double giveExp() const {return _b;};
  

protected:
  double _a, _b, _nu0, _dnu;
};
}
#endif
