// Classe d'initialisation du module TArray (template Arrays)
#include "machdefs.h"
#include "tarrinit.h"

#include "fioarr.h"

/*!
   \defgroup TArray TArray module
   This module contains arrays matrixes and vectors.
*/

/*!
  \class SOPHYA::TArrayInitiator
  \ingroup TArray
  Array Matrices and Vector initiator
*/

int TArrayInitiator::FgInit = 0;

TArrayInitiator::TArrayInitiator()
  : SophyaInitiator()
{
  FgInit++;
  if (FgInit > 1)  return;

//   Enregistrement des classes PPersist du modules TArray
  

  //  PPRegister(FIO_TArray<uint_1>);
  //  DObjRegister(FIO_TArray<uint_1>, TArray<uint_1>);
  PPRegister(FIO_TArray<uint_2>);
  DObjRegister(FIO_TArray<uint_2>, TArray<uint_2>);
  DObjRegister(FIO_TArray<uint_2>, TMatrix<uint_2>);
  DObjRegister(FIO_TArray<uint_2>, TVector<uint_2>);

  //  PPRegister(FIO_TArray<int_2>);
  //  DObjRegister(FIO_TArray<int_2>, TArray<int_2>);

  PPRegister(FIO_TArray<int_4>);
  DObjRegister(FIO_TArray<int_4>, TArray<int_4>);
  DObjRegister(FIO_TArray<int_4>, TMatrix<int_4>);
  DObjRegister(FIO_TArray<int_4>, TVector<int_4>);

  PPRegister(FIO_TArray<int_8>);
  DObjRegister(FIO_TArray<int_8>, TArray<int_8>);
  DObjRegister(FIO_TArray<int_8>, TMatrix<int_8>);
  DObjRegister(FIO_TArray<int_8>, TVector<int_8>);

  //  PPRegister(FIO_TArray<uint_4>);
  // DObjRegister(FIO_TArray<uint_4>, TArray<uint_4>);
  //  PPRegister(FIO_TArray<uint_8>);
  //  DObjRegister(FIO_TArray<uint_8>, TArray<uint_8>);
  PPRegister(FIO_TArray<r_4>);
  DObjRegister(FIO_TArray<r_4>, TArray<r_4>);
  DObjRegister(FIO_TArray<r_4>, TMatrix<r_4>);
  DObjRegister(FIO_TArray<r_4>, TVector<r_4>);

  PPRegister(FIO_TArray<r_8>);
  DObjRegister(FIO_TArray<r_8>, TArray<r_8>);
  DObjRegister(FIO_TArray<r_8>, TMatrix<r_8>);
  DObjRegister(FIO_TArray<r_8>, TVector<r_8>);

  PPRegister(FIO_TArray< complex<r_4> >);
  DObjRegister(FIO_TArray< complex<r_4> >, TArray< complex<r_4> >);
  DObjRegister(FIO_TArray< complex<r_4> >, TMatrix< complex<r_4> >);
  DObjRegister(FIO_TArray< complex<r_4> >, TVector< complex<r_4> >);

  PPRegister(FIO_TArray< complex<r_8> >);
  DObjRegister(FIO_TArray< complex<r_8> >, TArray< complex<r_8> >);
  DObjRegister(FIO_TArray< complex<r_8> >, TMatrix< complex<r_8> >);
  DObjRegister(FIO_TArray< complex<r_8> >, TVector< complex<r_8> >);

}

TArrayInitiator::~TArrayInitiator()
{
  FgInit--;
}


// On met un objet initiator en statique, pour les loaders qui savent 
// appeler le constructeur des objets statiques   Reza 08/98
static TArrayInitiator tarrayinit;

