//--------------------------------------------------------------------------
// File and Version Information:
//      $Id: squarefilt.cc,v 1.6 2000-04-14 07:28:14 ansari Exp $
//
// Description:
//
// History (add to end):
//      Sophie   Oct, 1999  - creation
//
//------------------------------------------------------------------------

//---------------
// C++ Headers --
//---------------
#include "machdefs.h"
#include <iostream.h>

#include "squarefilt.h"

/*! 
 * \class SOPHYA::SquareFilter
 \ingroup SkyT
 * Square detector response
 */

//----------------
// Constructor --
//----------------
SquareFilter::SquareFilter()
  : SpectralResponse()
{
}

SquareFilter::SquareFilter(double numin, double numax)
  : SpectralResponse(numin, numax)
{
  _nuPeak = (numin+numax)/2.;
  _peakTransmission = transmission(_nuPeak);
}


//--------------
// Destructor --
//--------------
SquareFilter::~SquareFilter()
{
}

//              ---------------------------
//              --  Function Definitions --
//              ---------------------------


/*! The transmission returns 1. for frequencies in the [numin,numax] range
  and 0. outside */ 
double 
SquareFilter::transmission(double nu) const
{
  if(nu < -1.e99) nu = -1.e99;
  if(nu > 1.e99) nu = 1.e99;
  
  if(nu>=_numin && nu<=_numax) return 1.;
  return 0.;
}

double 
SquareFilter::peakFreq() const 
{
return _nuPeak;
}

double 
SquareFilter::peakTransmission() const 
{
  return _peakTransmission;
}

/*
void 
SquareFilter::WriteSelf(POutPersist& s) 
{
  s.PutR8(this->minFreq());
  s.PutR8(this->maxFreq());
}

void 
SquareFilter::ReadSelf(PInPersist& s) 
{
  double minFreq, maxFreq;
  s.GetR8(_numin);
  s.GetR8(_numax);
  cout << "minFreq - maxFreq " <<  _numin << "-" << _numax  << endl;
}
*/
