// This may look like C code, but it is really -*- C++ -*-
// Classe Look-Up-Table  pour convertir image en entree ds
// une table de couleur.
//       Classe LUT              R. Ansari  05/95
// LAL (Orsay) / IN2P3-CNRS  DAPNIA/SPP (Saclay) / CEA

#ifndef LUT_SEEN
#define LUT_SEEN

// LUT : Look-Up-Table avec nLevel bins entre min et max
// Apply retourne * 0 < min   * nLevel+1 > max 
// et de 1 a nLevel pour min<=x<max

// Type de lut possibles (Seul Lineaire implemente 05/95
enum {kLutType_Lin=1, kLutType_Log=2};

class LUT 
{
public:

  int type;
  int nLevel;
  float * bornes;
  
  LUT(float min, float max, int ncol=16, int typ=kLutType_Lin);
  ~LUT();
  void SetLut(float min, float max, int typ=0);
  void Print();
  int Apply(float x);

  inline float Min() { return(bornes[0]); };
  inline float Max() { return(bornes[nLevel]); };
  inline int Type() { return(type); };
  inline int NCol() { return(nLevel+2); };
};

#endif



  
