#include <stdio.h>

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/cursorfont.h>

#include <X11/IntrinsicP.h>
#include <X11/CoreP.h>

#include "pixtbaseP.h"
#include "pixtbase.h"

#include "pibwdgx.h"


// #define DEBUG_PIBWDGX     Flag pour impression de debug etc ...
static unsigned long colpixwhite, colpixblack;
#define NMAXCURS 5 
static Cursor curs[NMAXCURS];


/* --Methode-- */
PIBaseWdgX::PIBaseWdgX(PIContainerGen *par, char *nom,
                       int sx, int sy, int px, int py) 
: PIBaseWdgGen(par, nom, sx, sy, px, py)

{
Arg  wargs[3];

Init();

CreateXtWdg(nom, piXtBaseWidgetClass, NULL, sx, sy, px, py);

XtSetArg(wargs[0],PIXNobject,this); 
XtSetArg(wargs[1],XtNbackground, colpixwhite);  
XtSetArg(wargs[2],XtNborderWidth, (Dimension)0);  
XtSetValues(XtWdg(), wargs, 3);

XtUninstallTranslations(XtWdg());

mPtrS = PI_CrossPointer;
SelPointerShape();

Manage();
mWGrC = new PIGraphicX(this);   // PIGraphic (Contexte graphique) associe a la fenetre
}


/* --Methode-- */
PIBaseWdgX::~PIBaseWdgX()
{
#ifdef DEBUG_PIBWDGX 
printf("PIBaseWdgX::~PIBaseWdgX()_Debug: Object= %lx (%lx) Wdg= %lx \n",
(long)this, (long)(((PIXtBaseWidget)XtWdg())->pixtbase.objet), (long)XtWdg() );  
#endif
Arg  wargs[2];
XtSetArg(wargs[0],PIXNobject,NULL); 
XtSetValues(XtWdg(), wargs, 1);
}

/* --Methode-- */
void PIBaseWdgX::FinishCreate()
{
// appele par la fenetre mere, apres XtRealize()
// J'active le backing store pour la fenetre X
XSetWindowAttributes xswa;
Window mwi;
mwi = XtWindow(XtWdg());
xswa.backing_store = WhenMapped;
xswa.backing_planes = ~0;
XChangeWindowAttributes(PIXDisplay(), XtWindow(XtWdg()), CWBackingPlanes|CWBackingStore, &xswa);
} 

/* --Methode-- */
void PIBaseWdgX::ActivatePtrCross()
{
XtTranslations trans;
trans = XtParseTranslationTable
        ("<Enter>: enter_pixtbase() \n <Leave>: leave_pixtbase()");
XtAugmentTranslations(XtWdg(), trans);
//XtFree((char *)trans);

return;
}


/* --Methode-- */
void PIBaseWdgX::ActivateButton(int bid)
{
XtTranslations trans;
char strans[256];
if ((bid<1) || (bid > 3))  return;
sprintf(strans,"<Btn%dDown>: bud%d_pixtbase() \n <Btn%dUp>: buu%d_pixtbase()",
        bid, bid, bid, bid);
trans = XtParseTranslationTable(strans);

XtAugmentTranslations(XtWdg(), trans);
// XtFree((char *)trans);
#ifdef DEBUG_PIBWDGX
printf("PIBaseWdgX::ActivateButton \n%s \n", strans);
#endif
return;
}

/* --Methode-- */
void PIBaseWdgX::ActivateMove(int bid)
{
XtTranslations trans;
char strans[256];
if ((bid<1) || (bid > 3))  return;
sprintf(strans,"<Btn%dMotion>: mov%d_pixtbase()", bid, bid);
//sprintf(strans,"Button%d <PtrMoved>: mov%d_pixtbase()", bid, bid);
trans = XtParseTranslationTable(strans);

XtAugmentTranslations(XtWdg(), trans);
// XtFree((char *)trans);
#ifdef DEBUG_PIBWDGX
printf("PIBaseWdgX::ActivateMove \n%s \n", strans);
#endif
return;
}


/* --Methode-- */
void PIBaseWdgX::ActivateKeyboard()
{
XtTranslations trans;
trans = XtParseTranslationTable("<Key>: keyb_pixtbase()");
XtAugmentTranslations(XtWdg(), trans);
// XtFree((char *)trans);
return;
}

/* --Methode-- */
void PIBaseWdgX::SetBackgroundColor(PIColors col)
{
Arg  wargs[2];
XtSetArg(wargs[0],XtNbackground, mWGrC->GetPixelValueforColor(col) );  
XtSetValues(XtWdg(), wargs, 1);
mBCol = col;
return;
}

/* --Methode-- */
void PIBaseWdgX::EraseWindow(int x0, int y0, int dx, int dy)
{
XClearArea (XtDisplay(XtWdg()),XtWindow(XtWdg()), x0, y0, dx, dy, False );
return;
}

/* --Methode-- */
void PIBaseWdgX::SelPointerShape(PIPointer ptr)  
{
if (ptr == mPtrS)  return;
if ( (ptr < 0) || (ptr >= NMAXCURS))  return;
if ( XtIsRealized(XtWdg()) )
  XDefineCursor(XtDisplay (XtWdg()), XtWindow(XtWdg()), curs[ptr]);
mPtrS = ptr;
return;
}

/* --Methode-- */
void PIBaseWdgX::AssignKeyboard()
{
XSetInputFocus(XtDisplay (XtWdg()), XtWindow(XtWdg()), RevertToParent, PIXGetLastEventTime());
}

/* --Methode-- */
PIColors   PIBaseWdgX::GetBackgroundColor()
{
return(mBCol);
}

/* --Methode-- */
PIPointer  PIBaseWdgX::GetPointerShape()
{
return (mPtrS);
}


static bool fgbwdg = false ;

/* --Methode-- */
void PIBaseWdgX::Init()
{
int i;

if (fgbwdg)  return;
fgbwdg = true;

Display *mdsp = PIXDisplay();
int scr = XDefaultScreen(mdsp);

colpixwhite = XWhitePixel(mdsp, scr);
colpixblack = XBlackPixel(mdsp, scr);

curs[0] = XCreateFontCursor(mdsp, XC_X_cursor);
for(i=1; i<NMAXCURS; i++)  curs[i] = curs[0];

curs[PI_ArrowPointer] =  XCreateFontCursor(mdsp, XC_arrow);
curs[PI_CrossPointer] =  XCreateFontCursor(mdsp, XC_crosshair);
curs[PI_HandPointer] =  XCreateFontCursor(mdsp, XC_hand2);
curs[PI_TDLRArrowPointer] =  XCreateFontCursor(mdsp, XC_fleur);

return;
}

/* --Methode-- */
void PIBaseWdgX::eXposeProcess(int x0, int y0, int dx, int dy)                                 
{ 
// Appel depuis le PIXtBaseWidget uniquement (ExposeEvt de Xt )
Draw(mWGrC, x0, y0, dx, dy);
CallDrawers(mWGrC, x0, y0, dx, dy); 
return;
}
