#ifndef PIDRAWER_H
#define PIDRAWER_H

#include "pibwdggen.h"
#include "pigraphuc.h"
#include <list>

enum {
  kStdAxes     = 0x0001,
  kBoxAxes     = 0x0002,
  kTicks       = 0x0004,
  kIntTicks    = 0x0010,
  kExtTicks    = 0x0020,
  kMajTicks    = 0x0040,
  kMinTicks    = 0x0080,
  kLabels      = 0x1000,
  kAxesDflt    = kStdAxes | kTicks | kLabels
};


class PIDrawer {
public:
                     PIDrawer();
  virtual           ~PIDrawer();

  virtual void       SetLimits(float xmin, float xmax, float ymin, float ymax,
                               int axrl=kAxeDirSame, int ayud=kAxeDirSame);

  virtual void       DrawAxes(PIGraphicUC* g, int flags = -1);
  virtual void       SetAxesFlags(int flags=kAxesDflt);
    
  virtual void       Draw(PIGraphicUC* g);
  virtual void       Draw(PIGraphicUC* g, float xmin, float ymin, float xmax, float ymax);    

  float XMin() const {return xMin;}
  float XMax() const {return xMax;}
  float YMin() const {return yMin;}
  float YMax() const {return yMax;}
  
  inline PIGraphicUC*    GetGraphicUC() { return(mGrUC); }

  int    LimitsFixed() const {return limitsFixed;}
  void   FreeLimits() {limitsFixed = 0;}

//  Les objets/methodes suivants devraient etre protected     
//  Pb avec acces depuis PIBaseWdgGen (Reza 11/07/97) 
  virtual  PIGraphicUC*  SetDrwWdg(PIBaseWdgGen* drw, int x0, int y0, int dx, int dy, PIGraphicGen* g);

//  Je declare en public a cause de cxx - Reza 11/07/97 
  struct DrwBWId { int id; PIBaseWdgGen* wdg; };
  
protected:
  friend class PIBaseWdgGen;
  virtual void       Attach(PIBaseWdgGen*, int id);
  virtual void       Detach(PIBaseWdgGen*, int id);

  void CalcTicks();

  void DrawHTicks(PIGraphicUC* g, float y, float tickUp, float tickDown, float xBeg, float xStep);
  void DrawVTicks(PIGraphicUC* g, float x, float tickLeft, float tickRight, float yBeg, float yStep);
  void DrawHLabels(PIGraphicUC* g, float y, float xBeg, float xStep, int just=0);
  void DrawVLabels(PIGraphicUC* g, float x, float yBeg, float yStep, int just=0);

  
  float xMin, xMax, yMin, yMax;  // Valeurs en unites user
  int xW0, yW0, xWd, yWd;        // Origine/largeur ds la fenetre de trace
  bool   aXdir, aYdir;           // Sens des axes horiz, vertical 
  int aXFlg, aYFlg;

  float xFirstMajTick, xFirstMinTick;
  float yFirstMajTick, yFirstMinTick;
  float xMajTickStep, xMinTickStep;
  float yMajTickStep, yMinTickStep;
  float xMajTickLen,  xMinTickLen;
  float yMajTickLen,  yMinTickLen;
  
  int limitsFixed;
  int axesFlags;
  
  PIBaseWdgGen* mBWdg;
  PIGraphicUC* mGrUC;

  list<DrwBWId>  mBWdgList;
  bool mDndfg;
  
};


#endif
