#ifndef PISCDRAWWDG_H
#define PISCDRAWWDG_H

#include <vector>

#include "pisysdep.h"
#include PIBWDG_H
#include PISTDWDG_H
#include PIWIN_H
#include "pidrawer.h"



class PIScDrawer;

class PIScDrawWdg : public PIBaseWdg {
public:
  enum {ClassId = 5300};

                     PIScDrawWdg(PIContainerGen *par, char *nom,
                                   int sx=10, int sy=10, int px=0, int py=0);
  virtual            ~PIScDrawWdg();

  virtual long       kind() {return ClassId; }

  virtual void       Resize();
  
  virtual void       Draw(PIGraphic* g);
  virtual void       Draw(PIGraphic* g, int x0, int y0, int dx, int dy);
  virtual void       DrawSelf(PIGraphicUC* g, float xmin, float ymin, float xmax, float ymax);
  
  void               SetLimits(float xmin, float xmax, float ymin, float ymax, 
                               int axrl=kAxeDirSame, int ayud=kAxeDirSame, bool tmp=false);

  void               SetAxesFlags(int flags=kAxesDflt);
  void               DrawAxes(PIGraphicUC* g, int flags = -1);

  void               AddScDrawer(PIScDrawer*, bool ad=false);   // Ajoute un ScDrawer
  void               RemoveScDrawer(PIScDrawer*);  // Ote un ScDrawer sans le detruire
  int                NbScDrawers();
  PIScDrawer*        ScDrawer(int i);          

  PIDrawer*          BaseDrawer() { return mBDrw; };

  float XMin() const {return mBDrw->XMin();}
  float XMax() const {return mBDrw->XMax();}
  float YMin() const {return mBDrw->YMin();}
  float YMax() const {return mBDrw->YMax();}
  float XPPos() const { return mPPos[0]; }
  float YPPos() const { return mPPos[1]; }
  int    LimitsFixed() const {return mBDrw->LimitsFixed();}
  void   FreeLimits() { mBDrw->FreeLimits(); }
    

  virtual string     GetClickText(float x, float y); // Donne le texte a afficher pour position x,y

  void               SetTextWin(PILabel * tw, bool trw=true, int tx=300, int ty=30);

  virtual void       But1Press(int x, int y);
  virtual void       But1Release(int x, int y);
  virtual void       Ptr1Move(int x, int y);

  virtual void       But2Press(int x, int y);
  virtual void       But2Release(int x, int y);
  virtual void       Ptr2Move(int x, int y);
  
protected:
          void       DeleteScDrawers();    // Ote et detruit tous les ScDrawers
          void       CallScDrawers(PIGraphicUC* g, float xmin, float ymin, float xmax, float ymax);
       PIGraphicUC*  SetSpan(PIGraphicGen* g);

  float xMinS, xMaxS, yMinS, yMaxS; // Sauvegarde pour zoom
  float mPPos[2];               // Position click souris X,Y

  PIDrawer* mBDrw;
  vector<PIScDrawer*>   mScDrawers;
  bool padsup;
  
  int xBegDrag, yBegDrag;
  int xEndDrag, yEndDrag;
  PIColors cForCol;
  PIGOMode cGOmod;  
  PIPointer cPointer;
  PILineAtt cLatt;
  PILabel * mTxw;  
  PILabel * mTrlb;
  PIWindow * mTrW;


private:
  bool  UpdateText(int xp, int yp);
};


class PIScDrawer {
public:
                     PIScDrawer();
  virtual           ~PIScDrawer();

  virtual void       Draw(PIGraphicUC* g, float xmin, float ymin, float xmax, float ymax) = 0; 
  virtual void       UpdateSize();   // Calcule et change les limites si non fixees 
  virtual void       Refresh();      // Recalcule les limites et reaffiche

  PIDrawer*          Convert();

  void               SetColAtt(PIColors fg=PI_NotDefColor, 
                                PIColors bg=PI_NotDefColor);
  void               SetLineAtt(PILineAtt lat=PI_NotDefLineAtt);
  void               SetFontAtt(PIFontSize fsz=PI_NotDefFontSize,
                                PIFontAtt fat=PI_NotDefFontAtt);
  void               SetMarkerAtt(int sz=-1, PIMarker mrk=PI_NotDefMarker);

  void               SelGraAtt(PIGraphicUC* g);

  inline void        SetAutoDelDataObj(bool ad=false) { mAdDO = ad; }
  inline bool        ADelByDrwWdg() { return mADbW; }
  inline bool        MainScDrawer() { return mPrDw; }

protected:
  friend class       PIScDrawWdg;
  virtual void       AttachTo(PIScDrawWdg*, bool, bool);

  PIScDrawWdg*       mDrawWdg;
  PIDrawer*          mDrawer;
  bool               mADbW, mAdDO, mPrDw;
  PIColors           mFCol, mBCol;
  PILineAtt          mLAtt;
  PIFontSize         mFSz;
  PIFontAtt          mFAtt;
  int                mMSz;
  PIMarker           mMrk;     
};

class PIScFuncDrawer : public PIScDrawer {
public:
  typedef double(*FUNC)(double);
                     PIScFuncDrawer(FUNC);
  virtual           ~PIScFuncDrawer();
  
  virtual void       Draw(PIGraphicUC* g, float xmin, float ymin, float xmax, float ymax);
protected:
  FUNC               mFunc;
};

class GeneralFunction;
class PIScGFFDrawer : public PIScDrawer {
public:
                     PIScGFFDrawer(GeneralFunction*);
  virtual           ~PIScGFFDrawer();
  
  virtual void       Draw(PIGraphicUC* g, float xmin, float ymin, float xmax, float ymax);
  virtual void       SetParms(double const*);
protected:
  GeneralFunction*    mFunc;
  int                 mNParms;
  double*             mParms;
};


#endif
