#include "pmixer.h"

/*!
 * \ingroup PMixer
 * \file Sph2Sph.cc
 *\brief   \b PROGRAM    \b Sph2Sphr  <BR>
 * From a map with a given Nside to another map with
 * another Nside -> this program performs the translation
 * from one to the other (and reverse)
 */

// -----------------------------------------------------------------
static POutPersist * so = NULL;  // Debug PPFOut file

// -------------------------------------------------------------------------
//                             main program 
// -------------------------------------------------------------------------
int main(int narg, char * arg[])
{
  if ((narg < 4) || ((narg > 1) && (strcmp(arg[1], "-h") == 0) )) {
    cout << "  Usage: Sph2Sph FITS_sphIn nside_out FITS_sphOut [PPF_sphOut]" << endl;
    exit(0);
  }
  InitTim();
  
  so = NULL;
  double moy,sig;
  int hp_nside = 16;
  SphereHEALPix<float> InSph(hp_nside);
  FITS_SphereHEALPix<float> fios(&InSph);
  fios.ReadF(arg[1],2);
  
  MeanSig(InSph.DataBlock(), moy, sig );
  cout << "Number of Pixels (input)  ->" <<  InSph.NbPixels() << endl;
  cout << "MeanSig of Input Map      ->" << moy << " " << sig << endl;

  string nSide = arg[2];
  int nsideOut = atof(nSide.c_str());
  SphereHEALPix<float> outgs(nsideOut);
  Sph2Sph(InSph,outgs);
  // Saving the output map in FITS format 
  FITS_SphereHEALPix<float> fios2(&outgs);
  fios2.Write(arg[3]);

  MeanSig(outgs.DataBlock(), moy, sig );
  cout << "Number of Pixels (output) ->" <<  outgs.NbPixels() << endl;
  cout << "MeanSig of Output Map     ->" << moy << " " << sig << endl;
  
  PrtTim("End of WriteFITS ");
  // Saving the output map in PPF format 
  if (narg > 4) {
    POutPersist s(arg[4]); 
    FIO_SphereHEALPix<float> fiog(&outgs) ;
    fiog.Write(s);
    cout << "Output Map (SphereHEALPix<float>) written to POutPersist file "  
	 << (string)(arg[3]) << endl;
    PrtTim("End of WritePPF ");
  }
  if (so) delete so;  //  Closing the debug ppf file 
}
