// This may look like C code, but it is really -*- C++ -*-
//  Usuall mathematical functions and operations on arrays
//                     R. Ansari, C.Magneville   03/2000

#ifndef MathArray_SEEN
#define MathArray_SEEN

#include "machdefs.h"
#include <math.h>
#include "tarray.h"

namespace SOPHYA {

//! Class for simple mathematical operation on arrays 
template <class T>
class MathArray {
public:
// Applying a function 
  // Replaces the input array content with the result f(x)
  virtual TArray<T>&  ApplyFunctionInPlace(TArray<T> & a, Arr_DoubleFunctionOfX f);
  virtual TArray<T>&  ApplyFunctionInPlace(TArray<T> & a, Arr_FloatFunctionOfX f);
  // Creates a new array and fills it with f(x)
  virtual TArray<T>  ApplyFunction(TArray<T> const & a, Arr_DoubleFunctionOfX f);
  virtual TArray<T>  ApplyFunction(TArray<T> const & a, Arr_FloatFunctionOfX f);
  // Computing Mean-Sigma 
  virtual double     MeanSigma(TArray<T> const & a, double & mean, double & sig);
};

////////////////////////////////////////////////
//  Calcul de fonctions usuelles 

  // #if !defined(OS_LINUX) && !defined (__KCC__)
#if !defined(__GNUG__)
// see below for g++   
/*! \ingroup TArray \fn fabs(const TArray<T>& a)
  \brief computation on TArray */
template <class T>
inline TArray<T> fabs(const TArray<T>& a)
  { MathArray<T> ma;   return( ma.ApplyFunction(a, fabs) ); }

/*! \ingroup TArray \fn sqrt(const TArray<T>& a)
  \brief computation on TArray */
template <class T>
inline TArray<T> sqrt(const TArray<T>& a)
  { MathArray<T> ma;   return( ma.ApplyFunction(a, sqrt) ); }

/*! \ingroup TArray \fn sin(const TArray<T>& a)
  \brief computation on TArray */
template <class T>
inline TArray<T> sin(const TArray<T>& a)
  { MathArray<T> ma;   return( ma.ApplyFunction(a, sin) ); }

/*! \ingroup TArray \fn cos(const TArray<T>& a)
  \brief computation on TArray */
template <class T>
inline TArray<T> cos(const TArray<T>& a)
  { MathArray<T> ma;   return( ma.ApplyFunction(a, cos) ); }

/*! \ingroup TArray \fn tan(const TArray<T>& a)
  \brief computation on TArray */
template <class T>
inline TArray<T> tan(const TArray<T>& a)
  { MathArray<T> ma;   return( ma.ApplyFunction(a, tan) ); }

/*! \ingroup TArray \fn asin(const TArray<T>& a)
  \brief computation on TArray */
template <class T>
inline TArray<T> asin(const TArray<T>& a)
  { MathArray<T> ma;   return( ma.ApplyFunction(a, asin) ); }

/*! \ingroup TArray \fn acos(const TArray<T>& a)
  \brief computation on TArray */
template <class T>
inline TArray<T> acos(const TArray<T>& a)
  { MathArray<T> ma;   return( ma.ApplyFunction(a, acos) ); }

/*! \ingroup TArray \fn atan(const TArray<T>& a)
  \brief computation on TArray */
template <class T>
inline TArray<T> atan(const TArray<T>& a)
  { MathArray<T> ma;   return( ma.ApplyFunction(a, atan) ); }

/*! \ingroup TArray \fn exp(const TArray<T>& a)
  \brief computation on TArray */
template <class T>
inline TArray<T> exp(const TArray<T>& a)
  { MathArray<T> ma;   return( ma.ApplyFunction(a, exp) ); }

/*! \ingroup TArray \fn lof(const TArray<T>& a)
  \brief computation on TArray */
template <class T>
inline TArray<T> log(const TArray<T>& a)
  { MathArray<T> ma;   return( ma.ApplyFunction(a, log) ); }

/*! \ingroup TArray \fn log10(const TArray<T>& a)
  \brief computation on TArray */
template <class T>
inline TArray<T> log10(const TArray<T>& a)
  { MathArray<T> ma;   return( ma.ApplyFunction(a, log10) ); }

#else
// g++ (up to 2.95.1) doesn't handle these inline template
// functions correctly - with math functions defined in math.h
#include "gcc_arrmath_pb.h"
#endif

/*! \ingroup TArray \fn MeanSigma(const TArray<T>&,double&,double&)
  \brief Return \b mean and \b sigma of elements of array \b a */
template <class T>
inline double MeanSigma(const TArray<T>& a, double & mean, double & sig)
  { MathArray<T> ma;   return( ma.MeanSigma(a, mean, sig) ); }

/*! \ingroup TArray \fn Mean(const TArray<T>&)
  \brief Return \b mean of elements of array \b a */
template <class T>
inline double Mean(const TArray<T>& a)
  { MathArray<T> ma;  double mean, sig;  return( ma.MeanSigma(a, mean, sig) ); }

} // Fin du namespace

#endif
