/* quelques fonctions mathematiques et constantes utiles */
/*                                         cmv  23/06/94 */
#ifndef NBCONST_H_SEEN
#define NBCONST_H_SEEN


#ifdef __cplusplus
extern "C" {
#endif

// EA conflit entre les diverses copies de nbmath.h, nbconst.h... A nettoyer...
#undef Pi
#undef Pis2
#undef DeuxPi
#undef SPi
#undef S2Pi
#undef Rac2
#undef Log2
#undef LnPi
#undef LgPi
#undef Ln10
#undef DftoDm
#undef Hln2pi
#undef DegenRad
#undef JourSec
#undef AnSec

#undef UAenKM
#undef UAenLY
#undef KPCenKM
#undef KPCenUA
#undef KPenLY
#undef LYenKM
#undef RSolenKM
#undef RTenKM
#undef MSolenKg
#undef GC_RE

#undef GRAND  
#undef GRAND2 
#undef IGRAND 

#define Pi     (double) (3.1415926535897931)   //!< Pi
#define Pis2   (double) (1.57079632679489655)  //!< Pi/2
#define DeuxPi (double) (6.2831853071795862)   //!< 2*Pi
#define SPi    (double) (1.7724538509055159)   //!< sqrt(Pi)
#define S2Pi   (double) (2.5066282746310002)   //!< sqrt(2*Pi)
#define Rac2   (double) (1.4142135623730950)   //!< sqrt(2)
#define Log2   (double) (0.30102999566398119)  //!< log10(2)
#define LnPi   (double) (1.1447298858494002)   //!< ln(Pi)
#define LgPi   (double) (0.49714987269413385)  //!< log10(Pi)
#define Ln10   (double) (2.3025850929940456)   //!< ln(10)
#define DftoDm (double) (1.0857362047581295)   //!< 2.5/ln(10)
#define Hln2pi (double) (0.91893853320467267)  //!< Ln(2*pi)/2
#define DegenRad (double) (0.0174532925199)    //!< nombre de radians dans un degre

#define JourSec (float) (86400.)    //!< nombre de secondes dans 24H
#define AnSec  (int) (31557600)     //!< nombre de secondes dans 365.25 jours

#define UAenKM (double) (149597870.) //!< nombre de kilometres dans une unite astronomique
#define UAenLY (double) (1.5812507406e-5) //!< unite astronomique en annees lumiere
#define KPCenKM (double) (3.0856775807e+16) //!< nombre de kilometres dans un kiloparsec
#define KPCenUA (double) (206264806.248) //!< nombre d'unites astronomiques dans un kiloparsec
#define KPenLY (double) (3261.5637763) //!< kiloparsec en annees lumiere
#define LYenKM (double) (9.4607304725808*e+12) //!< annee lumiere en kilometres
#define RSolenKM (double) (6.9599e+5) //!< Rayon solaire en kilometres
#define RTenKM (double) (6378.14) //!< rayon equatorial terrestre en kilometres

#define MSolenKg (double) (1.9891e+30) //!< masse solaire en kilogramme

#define GC_RE ((double) 4.7854172e-17) //!< G/c**2 en unites kpc/Mo

#define GRAND  (float) (1.e+35)
#define GRAND2 (double) (1.e+35)
#define IGRAND (int_4) (2147483647)

#ifdef __cplusplus
}
#endif

#endif
