\begin{verbatim}
#include "dvlist.h"
#include "ndatablock.h"
#include "fiondblock.h"
#include "sophyainit.h"

int main(int narg, char* arg[])
{
  // We handle exception at the high level
  try {
  // This macro initialize the library
  // static objects handle this - However, not all loader call
  // the constructor for static objects
  SophyaInit();

  // using a DVList object
  cout << " Creating and using DVList and NDataBlock<T> " << endl;
  DVList dvl;
  dvl["A"] = 12;
  dvl["bs"] = "hello";

  // Using a datablock object with 66 integers
  NDataBlock<int_4> idb(66);
  // We initialize all values with the value 15
  idb = 15;

  // Using a datablock object with 40 float
  NDataBlock<r_4> rdb(40);
  // We initialize all values with the value 3.14
  rdb = 3.14;

  // Writing (serialiazing) objects into POutPersist streams
  cout << " Writing objects in POutPersist streams " << endl;
      {  
      POutPersist so1("t11.ppf");
      so1 << dvl;
      POutPersist so2("t12.ppf");
      string nom = "idb";
      so2.PutObject(idb, nom);
      nom = "rdb";
      so2.PutObject(rdb, nom);
      }
  // Reading objects from PInPersist streams
  cout << " reading objects from PInPersist streams " << endl;
      {
      PInPersist si1("t11.ppf");
      DVList dvlr;
      si1 >> dvlr;
      cout << dvlr;     // Print on the standard output
      PInPersist si2("t12.ppf");
      string nom = "rdb";
      NDataBlock<r_4> rrdb;
      si2.GetObject(rrdb, nom);
      cout << rrdb;     // Print on the standard output
      NDataBlock<int_4> ridb;
      nom = "idb";
      si2.GetObject(ridb, nom);
      cout << ridb;     // Print on the standard output
      si2.GetObject(ridb, nom);      
      }

  // Opening an non existing file for reading generates an exception
  cout << " Generating an exception ... " << endl;
  PInPersist si("zz.zz");
  }
  catch (PThrowable & exc) {
    cerr << " Catched Exception " << (string)typeid(exc).name() 
	 << " - Msg= " << exc.Msg() << endl;
  }
  catch (...) {
    cerr << " some other exception was caught ! " << endl;
  }
}
\end{verbatim}
