#include <stdlib.h>
#include <stdio.h>

#include "lance.h"



Toto::Toto(int n)
{
  if (n < 1)  throw(myException(ExcLongMessage("Toto::Toto() Size<1")) );
  size = n;
  data = new double[n];
  for(int k=0; k<n; k++) data[k] = k;
}

Toto::~Toto()
{
  delete[] data;
}


int lance(int a, long sz);
int main(int narg, char *arg[])
{
  if (narg < 3) {
    cout << " Usage: lance 0/1/2/3/5 size \n" 
	 << "  0: Rien, 1: throw myException, 2: throw int \n" 
	 << "  3: throw exception 4: new double[size] " 
	 << "  5: class toto+acces aux elts"  << endl;
    return(0);
  }

  int rc,a;
  long sz;
  a = atoi(arg[1]);
  sz = atoi(arg[2]);
  cout << "\n ---- Lance , test exeception, a=" << a << " Sz=" << sz << endl; 
  try {
    rc = lance(a, sz);
    cout << " Return Code from lance= " << rc << endl;
  }
  catch(myException exc){
    cerr << " Catched myException : msg= " << exc.Msg() << endl;
    rc = 77;
  }
  catch (int ie) {
    cerr << "  Catched exception - integer= " << ie << endl;
    rc = 78;
  }
  catch(exception exc){
  // Classe de base des exception standard - 
  // La methode what() n'est pas forcement conforme a la norme 
    string msg = exc.what();
    cerr << " Catched exception : msg= " << msg << endl;
    rc = 98;
  }
  catch (...) {
    cerr << " Catched Unknown exception ! " << endl;
    rc = 99;
  }

  cout << " ------ Exiting from lance ----------------- \n" << endl;
  exit(rc);
}


int lance(int a, long sz)
{
  int rc = 0;
  char buff[128];
  double *d;
  switch(a){
  case 0:
    cout << " lance-0 / OK " << endl;
    break;
  case 1:
    cout << " lance-1 / throw myException " << endl;
    sprintf(buff,"lance() - File=%s Line=%d",__FILE__,__LINE__);
    throw myException(buff);
    break;
  case 2:
    cout << " lance-2 / throw integer 2001 " << endl;
    rc = 2001;
    throw rc;
    break;
  case 3:
    cout << " lance-3 / throw execption " << endl;
    throw exception();
    break;
  case 4:
    cout << " lance-4 / new double[ " << sz << " ]" << endl;
    d = new double[sz];
    rc = 4;
    break;
  case 5:
    {
    cout << " lance-5 / Toto( " << sz << " )" << endl;
    Toto t(sz);
    double s=0.;
    for(int kk=0; kk<=sz; kk++)   s+= t.Value(kk);
    cout << " Somme= " << s << endl;
    }
  default:
    rc = 9;
    break;
  }
  return(rc);
}
