#include <stdlib.h>
#include <stdio.h>

enum _VecTyp { INT, FLOAT, DOUBLE };
typedef enum _VecTyp VecTyp;

struct _vector
{
VecTyp vtyp;
int size;
union 
  {
  int *vi;
  float *vf;
  double *vd;
  } tab;
};
typedef struct _vector Vector;

Vector * NewVector(VecTyp typ, int sz, int fg);
void DeleteVector(Vector *v);
Vector * AddVector(Vector *v1, Vector *v2, Vector *v3);
Vector * MultVector(Vector *v1, Vector *v2, Vector *v3);

void InitTim();
void PrtTim(char *Comm);

Vector * NewVector(VecTyp typ, int sz, int fg)
{
Vector *vec;
int i;
int * ip;
float * fp;
double * dp;

if (sz < 1)  return(NULL);
vec = (Vector *)malloc(sizeof(Vector));
switch (typ)
  {
  case INT :
    vec->tab.vi = (int *)malloc(sizeof(int)*sz); 
    ip = vec->tab.vi;
    if (fg) for(i=0; i<sz; i++) ip[i] = 0;
    break;
  case FLOAT :
    vec->tab.vf = (float *)malloc(sizeof(float)*sz); 
    fp = vec->tab.vf;
    if (fg) for(i=0; i<sz; i++) fp[i] = 0.;
    break;
  case DOUBLE :
    vec->tab.vd = (double *)malloc(sizeof(double)*sz); 
    dp = vec->tab.vd;
    if (fg) for(i=0; i<sz; i++) dp[i] = 0.;
    break;
  default :
    puts(" Type inconnu ! ");
    free(vec);
    return(NULL);
    break;
  }
if (vec->tab.vi == NULL)  { free(vec); return(NULL); }
vec->size = sz;
vec->vtyp = typ;
return(vec); 
}

void DeleteVector(Vector *v)
{
switch (v->vtyp)
  {
  case INT :
    free(v->tab.vi);
    break;
  case FLOAT :
    free(v->tab.vf);
    break;
  case DOUBLE :
    free(v->tab.vd);
    break;
  }
free(v);
}

Vector * AddVector(Vector *v1, Vector *v2, Vector *v3)
{
register int i;
register int *ip1,*ip2,*ip3;
register float *fp1, *fp2, *fp3;
register double *dp1, *dp2, *dp3;

switch (v3->vtyp)
  {
  case INT :
    ip1 = v1->tab.vi;
    ip2 = v2->tab.vi;
    ip3 = v3->tab.vi;
    for (i=0; i<v3->size; i++)  ip3[i] = ip1[i] + ip2[i];  
    break;
  case FLOAT :
    fp1 = v1->tab.vf;
    fp2 = v2->tab.vf;
    fp3 = v3->tab.vf;
    for (i=0; i<v3->size; i++)  fp3[i] = fp1[i] + fp2[i];  
    break;
  case DOUBLE :
    dp1 = v1->tab.vd;
    dp2 = v2->tab.vd;
    dp3 = v3->tab.vd;
    for (i=0; i<v3->size; i++)  dp3[i] = dp1[i] + dp2[i];  
    break;
  default :
    puts(" Type inconnu ! ");
    return(NULL);
    break;
  }
return(v3); 
}

Vector * MultVector(Vector *v1, Vector *v2, Vector *v3)
{
register int i;
register int *ip1,*ip2,*ip3;
register float *fp1, *fp2, *fp3;
register double *dp1, *dp2, *dp3;

switch (v3->vtyp)
  {
  case INT :
    ip1 = v1->tab.vi;
    ip2 = v2->tab.vi;
    ip3 = v3->tab.vi;
    for (i=0; i<v3->size; i++)  ip3[i] = ip1[i] * ip2[i];  
    break;
  case FLOAT :
    fp1 = v1->tab.vf;
    fp2 = v2->tab.vf;
    fp3 = v3->tab.vf;
    for (i=0; i<v3->size; i++)  fp3[i] = fp1[i] * fp2[i];  
    break;
  case DOUBLE :
    dp1 = v1->tab.vd;
    dp2 = v2->tab.vd;
    dp3 = v3->tab.vd;
    for (i=0; i<v3->size; i++)  dp3[i] = dp1[i] * dp2[i];   
    break;
  default :
    puts(" Type inconnu ! ");
    return(NULL);
    break;
  }
return(v3); 
}


/* --------------------------------------------------------------------- */
/* --------------------------- Main Program ---------------------------- */
/* --------------------------------------------------------------------- */

int main (int narg, char *arg[])
{
int i,j, N, M, OPT, OPE, fg;
Vector *iv1, *iv2, *iv3;
Vector *fv1, *fv2, *fv3;
Vector *dv1, *dv2, *dv3;

if (narg < 2) { 
  printf("\n Usage: vectorC Type(=1,2,3 Int,Float,Double) Ope(=1/2/3/4) [N [M] ] \n");
  printf("Ope: 1=Create/Delete 2=1+FillVect 3=Add  4=Mult \n");
  printf("N: Number of operations (def= 100) \n");
  printf("M: Vector size (def= 50000) \n\n");
  exit(0);
}

 InitTim();

OPT = 1; OPE = 1;  fg = 0;
if (narg > 1)  OPT = atoi(arg[1]);
if ( (OPT < 1) || (OPT > 3) )  OPT = 1;

if (narg > 2)  OPE = atoi(arg[2]);
if ( (OPE < 1) || (OPE > 4) )  OPE = 1;

N = 100;if (narg > 3)  N = atoi(arg[3]);
if (N < 1) N = 1;
if (N > 100000) N = 100000;
M = 50000;
if (narg > 4)  M = atoi(arg[4]);
if (M < 1000) M = 1000;
if (M > 1000000) M = 1000000;

printf(" VectorC TestSpeed Typ=%d Ope=%d N=%d VSz=%d\n", OPT, OPE, N,M);

if (OPE < 3) { /* Test creation / destruction */
fg = OPE-1;
printf("\n\n Test New/DeleteVec - fg= %d ( <> 0 ---> FillVec) \n", fg); 
 switch (OPT)
   {
   case 1 :
     printf("Test %d NewVector/DeleteVector VecINT[%d] \n",N,M);
     for(i=0; i<N; i++) {
       iv1 = NewVector(INT, M, fg);
       DeleteVector(iv1);
     }
     break;
   case 2 :
     printf("Test %d NewVector/DeleteVector VecFLOAT[%d] \n",N,M);
     for(i=0; i<N; i++) {
       fv1 = NewVector(FLOAT, M, fg);
       DeleteVector(fv1);
     }
     break;
   case 3 :
     printf("Test %d NewVector/DeleteVector VecDOUBLE[%d] \n",N,M);
     for(i=0; i<N; i++) {
       dv1 = NewVector(DOUBLE, M, fg);
       DeleteVector(dv1);
     }
     break;
  }
  PrtTim("Fin New/Delete ");
  printf("Fin de Vector/C \n");
  return (0);
}

/* ---------- Test Addition, Multiplication ------------- */
switch (OPT)
  {
  case 1 :
    printf("\n\n Test %d operations VecINT[%d] \n",N,M);
    iv1 = NewVector(INT, M, fg);
    iv2 = NewVector(INT, M, fg);
    iv3 = NewVector(INT, M, fg);

    PrtTim("Fin_Creation ");
    for(i=0; i<M; i++)  
      { 
      iv1->tab.vi[i] = random()%1000;
      iv2->tab.vi[i]= random()%5000; }

    PrtTim("Fin remplissage ");
    if (OPE == 3) {
      for(i=0; i<N; i++) 
        AddVector(iv1, iv2, iv3); 
      PrtTim("Fin Addition ");
    }
    else {
      for(i=0; i<N; i++) 
        MultVector(iv1, iv2, iv3); 
      PrtTim("Fin Multiplication ");
    }

    printf("Result[1.2] I1= %d %d  I2= %d %d  I3= %d %d \n",
           iv1->tab.vi[1], iv1->tab.vi[2], iv2->tab.vi[1], iv2->tab.vi[2],
           iv3->tab.vi[1], iv3->tab.vi[2]);

    printf("Result[991-2] I1= %d %d  I2= %d %d  I3= %d %d \n",
           iv1->tab.vi[991], iv1->tab.vi[992], iv2->tab.vi[991], iv2->tab.vi[992],
           iv3->tab.vi[991], iv3->tab.vi[992]);
    break;
  
  case 2 :
    printf("\n\n Test %d operations VecFLOAT[%d] \n",N,M);
    InitTim();

    fv1 = NewVector(FLOAT, M, fg);
    fv2 = NewVector(FLOAT, M, fg);
    fv3 = NewVector(FLOAT, M, fg);

    PrtTim("Fin_Creation ");
    for(i=0; i<M; i++)  
      { 
      fv1->tab.vf[i] = (float)(random()%1000)/250.;
      fv2->tab.vf[i]= (float)(random()%5000)/250.; }

    PrtTim("Fin remplissage ");
    if (OPE == 3) {
      for(i=0; i<N; i++) 
        AddVector(fv1, fv2, fv3); 
      PrtTim("Fin Addition ");
    }
    else {
      for(i=0; i<N; i++) 
        MultVector(fv1, fv2, fv3); 
      PrtTim("Fin Multiplication ");
    }
    printf("Result[1.2] F1= %g %g  F2= %g %g  F3= %g %g \n",
           fv1->tab.vf[1], fv1->tab.vf[2], fv2->tab.vf[1], fv2->tab.vf[2],
           fv3->tab.vf[1], fv3->tab.vf[2]);

    printf("Result[991-2] F1= %g %g  F2= %g %g  F3= %g %g \n",
           fv1->tab.vf[991], fv1->tab.vf[992], fv2->tab.vf[991], fv2->tab.vf[992],
           fv3->tab.vf[991], fv3->tab.vf[992]);
    break;
  
  
  case 3 :
    printf("\n\n Test %d operations VecDOUBLE[%d] \n",N,M);
    InitTim();

    dv1 = NewVector(DOUBLE, M, fg);
    dv2 = NewVector(DOUBLE, M, fg);
    dv3 = NewVector(DOUBLE, M, fg);

    PrtTim("Fin_Creation ");
    for(i=0; i<M; i++)  
      { 
      dv1->tab.vd[i] = (double)(random()%1000)/250.;
      dv2->tab.vd[i]= (double)(random()%5000)/250.; }

    PrtTim("Fin remplissage ");
    if (OPE == 3) {
      for(i=0; i<N; i++) 
        AddVector(dv1, dv2, dv3); 
      PrtTim("Fin Addition ");
    }
    else {
      for(i=0; i<N; i++) 
        MultVector(dv1, dv2, dv3); 
      PrtTim("Fin Multiplication ");
    }

    printf("Result[1.2] D1= %g %g  D2= %g %g  D3= %g %g \n",
           dv1->tab.vd[1], dv1->tab.vd[2], dv2->tab.vd[1], dv2->tab.vd[2],
           dv3->tab.vd[1], dv3->tab.vd[2]);

    printf("Result[991-2] D1= %g %g  D2= %g %g  D3= %g %g \n",
           dv1->tab.vd[991], dv1->tab.vd[992], dv2->tab.vd[991], dv2->tab.vd[992],
           dv3->tab.vd[991], dv3->tab.vd[992]);
    break;
  
  default:
    puts("Erreur d'option !");
    break;
  }


PrtTim("Fin de Vector/C ");
return (0);
}

