<?php

include ('Faisceau.php');
include ('Cavit.php');
include ('Cible.php');

class Paramtres
{
  var $script;
  var $http;
  var $name;
  var $uri;

  var $twiss = 1;
  var $nergie = 2;

  var $champ = 3;
  var $longueur = 4;

  var $largeur = 5;

  var $paisseur = 6;

  function Paramtres ()
    {
      $this->http = "http" . ((!empty($_SERVER['HTTPS'])) ? "s" : "") . ":";
      $this->name = "//" . $_SERVER['SERVER_NAME'];
      $this->uri = $_SERVER['REQUEST_URI'];

      $this->script = $this->http . $this->name . $this->uri;

      $pos = strpos ($this->uri, "/pspa.php");
      $this->base = $this->http . $this->name . substr ($this->uri, 0, $pos);
     }
};

$Paramtres = new Paramtres ();

class TRANSPORT
{
  function TRANSPORT ()
    {
    }

  function run ($faisceau, $cavit)
    {
      global $Paramtres;

      $string = '<pspa></pspa>';

      $xml = new SimpleXMLElement($string);

      $f = $xml->addChild ("faisceau");
      $f->addAttribute ("twiss", $faisceau->twiss);
      $f->addAttribute ("energie", $faisceau->nergie);
      $c = $xml->addChild ("cavite");
      $c->addAttribute ("longueur", $cavit->longueur);
      $c->addAttribute ("champ", $cavit->champ);

      $xml->asXML('transport.xml');

      $sortie = new Faisceau ();
 
      //$h = popen ("Transport.exe transport.data", "r");

      $input = $Paramtres->base . "/Transport.php?data=transport.xml";
      echo "Transport: input={$input}<br>";
      $h = fopen ($input, "r");

      if ($h)
        {
          echo "Transport ok<br>";
          $s = '';
          while (($buffer = fgets ($h)) !== false)
            {
              $buffer = trim ($buffer);
              $s .= $buffer;
            }
          //echo htmlentities($s);
          //echo "<br>";

          $xml = new SimpleXMLElement($s);
          //print_r ($xml);
          //echo "<br>";

          $f = $xml->faisceau;
          $sortie->twiss = (double) $f['twiss'];
          $sortie->nergie = (double) $f['energie'];

          fclose ($h);
        }
      else
        {
          echo "impossible de lancer Transport<br>";
        }

      return ($sortie);
    }
};

class EGS
{
  function EGS ()
    {
    }

  function run ($cible, $faisceau)
    {
      global $Paramtres;

      $string = '<pspa></pspa>';

      $xml = new SimpleXMLElement($string);

      $f = $xml->addChild ("faisceau");
      $f->addAttribute ("twiss", $faisceau->twiss);
      $f->addAttribute ("energie", $faisceau->nergie);
      $c = $xml->addChild ("cible");
      $c->addAttribute ("epaisseur", $cible->paisseur);

      $xml->asXML('egs.xml');

      $sortie = array();
      $f = new Faisceau ();

      $first = true;

      //$h = popen ("EGS.exe egs.data", "r");

      $input = $Paramtres->base . "/EGS.php?data=egs.xml";
      echo "EGS: input={$input}<br>";
      $h = fopen ($input, "r");
      if ($h)
        {
          echo "EGS ok<br>";
          $s = '';
          while (($buffer = fgets ($h)) !== false)
            {
              $buffer = trim ($buffer);
              $s .= $buffer;
            }
          //echo htmlentities($s);
          //echo "<br>";

          $xml = new SimpleXMLElement($s);

          foreach ($xml as $k => $v)
            {
              $nom = (string) $v;
              $f = new Faisceau ($nom, (double) $v['twiss'], (double) $v['energie']);
              $sortie[$f->nom] = $f;
            }

          fclose ($h);
        }

      return ($sortie);
    }
};



class Control
{
  function header ()
    {
      echo "
<html>
<head>
<style type='text/css'>
</style>
</head>
";
    }


  function get_post ()
    {
      global $_POST;
      global $Paramtres;

      foreach ($_POST as $cle => $value)
	{
          $words = explode ('_', $cle);

          $n = count ($words);

          $classe = $words[0];
          $champ = '';
          if ($n > 1) $champ = str_replace ($classe . '_', '', $cle);

          if (is_array ($value))
            {
              $str = "cle=($cle) _POST[{$classe}.{$champ}]=";
            }
          else
            {
              $Paramtres->$cle = $value;
            }
	}
    }


  function faisceau_entre ()
    {
      global $Paramtres;

      echo "
  <tr>
    <td>
      <b><i>Dfinition du faisceau d'entre</i></b>
    </td>
    <td>
      Twiss
    </td>
    <td>
      <input type='text' name='twiss' value='{$Paramtres->twiss}' size='6'>
    </td>
    <td>
      Energie
    </td>
    <td>
      <input type='text' name='nergie' value='{$Paramtres->nergie}' size='6'>
MeV
    </td>
  </tr>
";

    }

  function cavit ()
    {
      global $Paramtres;

      echo "
  <tr>
    <td>
      <b><i>Dfinition de la cavit</i></b>
    </td>
    <td>
      Champ
    </td>
    <td>
      <input type='text' name='champ' value='{$Paramtres->champ}' size='6'>
MV/m
    </td>
    <td>
      Longueur
    </td>
    <td>
      <input type='text' name='longueur' value='{$Paramtres->longueur}' size='6'>
m
    </td>
  </tr>
";

    }

  function distribution ()
    {
      global $Paramtres;

      echo "
  <tr>
    <td>
      <b><i>Distribution des particules</i></b>
    </td>
    <td>
      Largeur
    </td>
    <td>
      <input type='text' name='largeur' value='{$Paramtres->largeur}' size='6'>
m
    </td>
  </tr>
";

    }


  function cible ()
    {
      global $Paramtres;

      echo "
  <tr>
    <td>
      <b><i>Dfinition de la cible</i></b>
    </td>
    <td>
      Epaisseur
    </td>
    <td>
      <input type='text' name='paisseur' value='{$Paramtres->paisseur}' size='6'>
cm
    </td>
  </tr>
";

    }

  function faisceaux_sortie ($lectrons, $photons, $positrons)
    {
      global $Paramtres;

      echo "
<table>
  <tr>
    <td colspan='2'>
      <center><hr></center>
    </td>
    <td>
      <center><i>Sortie</i></center>
    </td>
    <td colspan='2'>
      <center><hr></center>
    </td>
  </tr>
  <tr>
    <td>
      <b><i>Electrons</i></b>
    </td>
    <td>
      Twiss
    </td>
    <td>
      {$lectrons->twiss}
    </td>
    <td>
      Energie
    </td>
    <td>
      {$lectrons->nergie} MeV
    </td>
  </tr>
  <tr>
    <td>
      <b><i>Photons</i></b>
    </td>
    <td>
      Twiss
    </td>
    <td>
      {$photons->twiss}
    </td>
    <td>
      Energie
    </td>
    <td>
      {$photons->nergie} MeV
    </td>
  </tr>
  <tr>
    <td>
      <b><i>Positrons</i></b>
    </td>
    <td>
      Twiss
    </td>
    <td>
      {$positrons->twiss}
    </td>
    <td>
      Energie
    </td>
    <td>
      {$positrons->nergie} MeV
    </td>
  </tr>
</table>
";

    }

  function step1 ($faisceaux = null)
    {
      global $Paramtres;

      echo "
<table>
  <form enctype='multipart/form-data' action='{$Paramtres->script}' method='post'>
  <tr>
    <td colspan='5'>
      <i>Step 1</i>
    </td>
  </tr>
";

      $this->faisceau_entre ();
      $this->cavit ();

      echo "
<tr>
  <td>
    <input name='largeur' value='{$Paramtres->largeur}' type='hidden' />
    <input name='paisseur' value='{$Paramtres->paisseur}' type='hidden' />
    <input type='submit' name='submit' value='Run'>
  </td>
</tr>
";

      echo "
  </form>
</table>
";

      echo "
<tr>
  <td colspan='5'>
    <center><hr></center>
  </td>
</tr>
";

      echo "
<tr>
  <td colspan='5'>
    <center>TRANSPORT</center>
  </td>
</tr>
";

      $faisceau = new Faisceau ("", $Paramtres->twiss, $Paramtres->nergie);
      $cavit = new Cavit ($Paramtres->champ, $Paramtres->longueur);

      $transport = new TRANSPORT ();
      $faisceau_intermdiaire = $transport->run ($faisceau, $cavit);

      //echo "twiss={$faisceau_intermdiaire->twiss}<br>";
      //echo "nergie={$faisceau_intermdiaire->nergie}<br>";

    echo "
<tr>
  <td colspan='5'>
    <center><hr></center>
  </td>
</tr>
";

      $sortie = array ("lectrons" => $faisceau_intermdiaire);

      return ($sortie);
    }

  function step2 ($faisceaux)
    {
      global $Paramtres;

      $faisceau = NULL;
      foreach ($faisceaux as $k => $f)
        {
          $faisceau = $f;
        }

      echo "
<table>
  <form enctype='multipart/form-data' action='{$Paramtres->script}' method='post'>
  <tr>
    <td colspan='5'>
      <i>Step 2</i>
    </td>
  </tr>
";

      $this->distribution ();
      $this->cible ();

      echo "
<tr>
  <td>
    <input name='twiss' value='{$Paramtres->twiss}' type='hidden' />
    <input name='nergie' value='{$Paramtres->nergie}' type='hidden' />
    <input name='champ' value='{$Paramtres->champ}' type='hidden' />
    <input name='longueur' value='{$Paramtres->longueur}' type='hidden' />
    <input type='submit' name='submit' value='Run'>
  </td>
</tr>
";

      echo "
  </form>
</table>
";

      echo "
<tr>
  <td colspan='5'>
    <center><hr></center>
  </td>
</tr>

<tr>
  <td colspan='5'>
    <center>EGS</center>
  </td>
</tr>
";

      $cible = new Cible ($Paramtres->paisseur);

      $egs = new EGS ();
      $sortie = $egs->run ($cible, $faisceau);

    echo "
<tr>
  <td colspan='5'>
    <center><hr></center>
  </td>
</tr>
";

      return ($sortie);
    }

  function init ()
    {
      global $Paramtres;

      $this->get_post ();
      $this->header ();
    }

  function run ()
    {
      global $Paramtres;

/*
      echo "
<table>
  <tr>
    <td><center>
      <b><i>Valeurs</i></b>
    </center></td>
    <td><center>
      Twiss = {$Paramtres->twiss} Energie = {$Paramtres->nergie} Champ={$Paramtres->champ} Largeur = {$Paramtres->largeur}
Epaisseur={$Paramtres->paisseur}
    </center></td>
  </tr>
</table>
<hr>
";
*/

      $steps = array ('Transport' => 'step1', 'EGS' => 'step2');

      $this->init ();

      $faisceaux = null;

      foreach ($steps as $step => $action)
        {
          $faisceaux = $this->$action ($faisceaux);
        }

/*
      foreach ($faisceaux as $n => $f)
       {
          echo "s[$n]={$f->nom}<br>";
        }
*/
      $lectrons = $faisceaux["electrons"];
      $photons = $faisceaux["photons"];
      $positrons = $faisceaux["positrons"];

      $this->faisceaux_sortie ($lectrons, $photons, $positrons);
    }
};

$C = new Control ();

$C->run ();


?>
